/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.commands;

import chatty.Helper;
import chatty.gui.Channels;
import chatty.gui.GuiUtil;
import chatty.gui.components.Channel;
import chatty.gui.components.ChannelEditBox;
import chatty.util.StringUtil;
import chatty.util.commands.Item;
import chatty.util.commands.Parameters;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.SecondaryLoop;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Objects;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class Input
implements Item {
    private final boolean isRequired;
    private final Item type;
    private final Item message;
    private final Item initial;

    public Input(Item type, Item message, Item initial, boolean isRequired) {
        this.type = type;
        this.message = message;
        this.initial = initial;
        this.isRequired = isRequired;
    }

    @Override
    public String replace(Parameters parameters) {
        String messageValue = null;
        if (this.message != null && (messageValue = this.message.replace(parameters)) == null) {
            return null;
        }
        String initialValue = null;
        if (this.initial != null && (initialValue = this.initial.replace(parameters)) == null) {
            return null;
        }
        String typeValue = null;
        if (this.type != null && (typeValue = this.type.replace(parameters)) == null) {
            return null;
        }
        String result = new InputResult().getResult(typeValue, messageValue, initialValue, parameters);
        if (!Item.checkReq(this.isRequired, result)) {
            return null;
        }
        return result;
    }

    public String toString() {
        return "Input " + this.type + " '" + this.message + "' " + this.initial + "";
    }

    @Override
    public Set<String> getIdentifiersWithPrefix(String prefix) {
        return Item.getIdentifiersWithPrefix(prefix, this.type, this.message, this.initial);
    }

    @Override
    public Set<String> getRequiredIdentifiers() {
        return Item.getRequiredIdentifiers(this.isRequired, this.type, this.message, this.initial);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Input other = (Input)obj;
        if (this.isRequired != other.isRequired) {
            return false;
        }
        if (!Objects.equals(this.type, other.type)) {
            return false;
        }
        if (!Objects.equals(this.message, other.message)) {
            return false;
        }
        return Objects.equals(this.initial, other.initial);
    }

    public int hashCode() {
        int hash = 5;
        hash = 83 * hash + (this.isRequired ? 1 : 0);
        hash = 83 * hash + Objects.hashCode(this.type);
        hash = 83 * hash + Objects.hashCode(this.message);
        hash = 83 * hash + Objects.hashCode(this.initial);
        return hash;
    }

    private static class InputResult {
        private String result;

        private InputResult() {
        }

        public String getResult(String type, String msg, String preset, Parameters parameters) {
            GuiUtil.edtAndWait(() -> {
                Window activeWindow = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
                this.result = "simple".equals(type) ? JOptionPane.showInputDialog(activeWindow, msg, preset) : InputDialog.showInputDialog(activeWindow, parameters.get("chan"), msg, preset);
            }, "Custom Command Input");
            return this.result;
        }
    }

    private static class InputDialog
    extends JDialog {
        private final ChannelEditBox input;
        private String result;

        public static String showInputDialog(Window owner, String chan, String msg, String preset) {
            chan = Helper.toChannel(chan);
            Channels channels = Channels.getInstance();
            Channel channel = channels.getExistingChannel(chan);
            if (channel == null) {
                channel = channels.getActiveChannel();
            }
            if (channel == null) {
                return JOptionPane.showInputDialog(owner, msg, preset);
            }
            InputDialog dialog = new InputDialog(owner, channel, msg, preset);
            final SecondaryLoop loop = Toolkit.getDefaultToolkit().getSystemEventQueue().createSecondaryLoop();
            dialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    loop.exit();
                }

                @Override
                public void windowClosing(WindowEvent e) {
                    loop.exit();
                }
            });
            dialog.setVisible(true);
            loop.enter();
            return dialog.getResult();
        }

        public InputDialog(Window owner, Channel channel, String msg, String preset) {
            this.setTitle("Custom Command Input (" + channel.getChannel() + ")");
            this.input = channel.createInputBox();
            this.input.setColumns(40);
            this.input.setForeground(this.input.getForeground());
            this.input.setBackground(this.input.getBackground());
            this.input.addActionListener(e -> this.ok());
            this.input.setText(preset);
            this.setLayout(new GridBagLayout());
            JButton okButton = new JButton("OK");
            JButton cancelButton = new JButton("Cancel");
            GridBagConstraints gbc = new GridBagConstraints();
            if (!StringUtil.isNullOrEmpty(msg)) {
                gbc.gridx = 0;
                gbc.gridy = 0;
                gbc.anchor = 17;
                gbc.insets = new Insets(5, 5, 0, 5);
                this.add((Component)new JLabel(msg), gbc);
            }
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.gridwidth = 2;
            gbc.fill = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.insets = new Insets(5, 5, 5, 5);
            this.add((Component)this.input, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.weightx = 1.0;
            gbc.anchor = 13;
            gbc.insets = new Insets(5, 5, 5, 5);
            this.add((Component)okButton, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 2;
            gbc.insets = new Insets(5, 5, 5, 5);
            this.add((Component)cancelButton, gbc);
            okButton.addActionListener(e -> this.ok());
            cancelButton.addActionListener(e -> this.dispose());
            GuiUtil.addChangeListener(this.input.getDocument(), e -> SwingUtilities.invokeLater(() -> this.pack()));
            this.pack();
            this.setLocationRelativeTo(owner);
            this.setResizable(false);
            this.setAlwaysOnTop(true);
            GuiUtil.installEscapeCloseOperation(this);
        }

        private void ok() {
            this.result = this.input.getText();
            this.dispose();
        }

        public String getResult() {
            return this.result;
        }
    }
}

