/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.commands;

import chatty.User;
import chatty.gui.Highlighter;
import chatty.util.commands.Item;
import chatty.util.commands.Parameters;
import chatty.util.irc.MsgTags;
import java.util.Objects;
import java.util.Set;

public class Is
implements Item {
    private final Item item;
    private final boolean isRequired;

    public Is(Item item, boolean isRequired) {
        this.item = item;
        this.isRequired = isRequired;
    }

    @Override
    public String replace(Parameters parameters) {
        String value = this.item.replace(parameters);
        if (!Item.checkReq(this.isRequired, value)) {
            return null;
        }
        Highlighter.HighlightItem hl = new Highlighter.HighlightItem(value);
        User user = (User)parameters.getObject("user");
        User localUser = (User)parameters.getObject("localUser");
        String msg = parameters.get("msg");
        String result = "";
        if (hl.matches(Highlighter.HighlightItem.Type.ANY, msg, user, localUser, MsgTags.EMPTY)) {
            result = "true";
        }
        return Item.checkReq(this.isRequired, result) ? result : null;
    }

    public String toString() {
        return "Is " + this.item;
    }

    @Override
    public Set<String> getIdentifiersWithPrefix(String prefix) {
        return Item.getIdentifiersWithPrefix(prefix, this.item);
    }

    @Override
    public Set<String> getRequiredIdentifiers() {
        return Item.getRequiredIdentifiers(this.isRequired, this.item);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Is other = (Is)obj;
        if (!Objects.equals(this.item, other.item)) {
            return false;
        }
        return this.isRequired == other.isRequired;
    }

    public int hashCode() {
        int hash = 7;
        hash = 47 * hash + Objects.hashCode(this.item);
        hash = 47 * hash + (this.isRequired ? 1 : 0);
        return hash;
    }
}

