/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.commands;

import chatty.util.commands.Parameters;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

interface Item {
    public String replace(Parameters var1);

    public Set<String> getIdentifiersWithPrefix(String var1);

    public Set<String> getRequiredIdentifiers();

    public static Set<String> getRequiredIdentifiers(boolean isRequired, Object ... input) {
        if (isRequired) {
            return Item.getIdentifiersWithPrefix("", input);
        }
        return null;
    }

    public static Set<String> getIdentifiersWithPrefix(String prefix, Object ... input) {
        return Item.getIdentifiersWithPrefix(prefix, false, input);
    }

    public static Set<String> getIdentifiersWithPrefix(String prefix, boolean required, Object ... input) {
        HashSet<String> output = new HashSet<String>();
        for (Object value : input) {
            if (value == null) continue;
            if (value instanceof String) {
                if (!((String)value).startsWith(prefix)) continue;
                output.add((String)value);
                continue;
            }
            if (value instanceof List) {
                for (Object o : (List)value) {
                    if (!(o instanceof Item)) continue;
                    Item.addItemIdentifiers(prefix, required, (Item)o, output);
                }
                continue;
            }
            if (!(value instanceof Item)) continue;
            Item.addItemIdentifiers(prefix, required, (Item)value, output);
        }
        return output;
    }

    public static void addItemIdentifiers(String prefix, boolean required, Item item, Set<String> result) {
        Set<String> value = required ? item.getRequiredIdentifiers() : item.getIdentifiersWithPrefix(prefix);
        if (value != null) {
            result.addAll(value);
        }
    }

    public static boolean checkReq(boolean isRequired, String ... values) {
        for (String value : values) {
            if (value == null) {
                return false;
            }
            if (!isRequired || !value.isEmpty()) continue;
            return false;
        }
        return true;
    }
}

