/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.commands;

import chatty.util.commands.Item;
import chatty.util.commands.Literal;
import chatty.util.commands.Parameters;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;

class Items
implements Item {
    private final List<Item> collection;
    private StringBuilder builder = new StringBuilder();

    public Items() {
        this.collection = new ArrayList<Item>();
    }

    public Items(List<Item> collection) {
        this.collection = collection;
    }

    public void add(Item item) {
        this.flush();
        this.collection.add(item);
    }

    public void add(String literal) {
        this.builder.append(literal);
    }

    public Item getItem(int index) {
        return this.collection.get(index);
    }

    public void flush() {
        if (this.builder.length() > 0) {
            this.collection.add(new Literal(this.builder.toString()));
            this.builder = new StringBuilder();
        }
    }

    public boolean isEmpty() {
        return this.collection.isEmpty();
    }

    @Override
    public String replace(Parameters parameters) {
        StringBuilder b = new StringBuilder();
        for (Item item : this.collection) {
            String replaced = item.replace(parameters);
            if (replaced == null) {
                return null;
            }
            b.append(replaced);
        }
        return b.toString();
    }

    public String toString() {
        return this.collection.toString();
    }

    @Override
    public Set<String> getIdentifiersWithPrefix(String prefix) {
        return Item.getIdentifiersWithPrefix(prefix, this.collection.toArray());
    }

    @Override
    public Set<String> getRequiredIdentifiers() {
        return Item.getIdentifiersWithPrefix("", true, this.collection.toArray());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        Items other = (Items)obj;
        return Objects.equals(this.collection, other.collection);
    }

    public int hashCode() {
        int hash = 3;
        hash = 83 * hash + Objects.hashCode(this.collection);
        return hash;
    }
}

