/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.commands;

import chatty.util.commands.Item;
import chatty.util.commands.Items;
import chatty.util.commands.Parameters;
import java.util.Objects;
import java.util.Set;

class Join
implements Item {
    private final boolean isRequired;
    private final Item identifier;
    private final Items separator;

    public Join(Item identifier, Items separator, boolean isRequired) {
        this.identifier = identifier;
        this.separator = separator;
        this.isRequired = isRequired;
    }

    @Override
    public String replace(Parameters parameters) {
        String value = this.identifier.replace(parameters);
        if (!Item.checkReq(this.isRequired, value)) {
            return null;
        }
        String sep = this.separator.replace(parameters);
        if (sep == null) {
            return null;
        }
        return value.replaceAll(" ", sep);
    }

    public String toString() {
        return "Join " + this.identifier + "/" + this.separator;
    }

    @Override
    public Set<String> getIdentifiersWithPrefix(String prefix) {
        return Item.getIdentifiersWithPrefix(prefix, this.identifier, this.separator);
    }

    @Override
    public Set<String> getRequiredIdentifiers() {
        return Item.getRequiredIdentifiers(this.isRequired, this.identifier, this.separator);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Join other = (Join)obj;
        if (this.isRequired != other.isRequired) {
            return false;
        }
        if (!Objects.equals(this.identifier, other.identifier)) {
            return false;
        }
        return Objects.equals(this.separator, other.separator);
    }

    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + (this.isRequired ? 1 : 0);
        hash = 29 * hash + Objects.hashCode(this.identifier);
        hash = 29 * hash + Objects.hashCode(this.separator);
        return hash;
    }
}

