/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.commands;

import chatty.util.commands.Item;
import chatty.util.commands.Parameters;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Logger;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

class Json
implements Item {
    private static final Logger LOGGER = Logger.getLogger(Json.class.getName());
    private final boolean isRequired;
    private final Item input;
    private final Item output;

    public Json(Item input, Item output, boolean isRequired) {
        this.input = input;
        this.output = output;
        this.isRequired = isRequired;
    }

    @Override
    public String replace(Parameters parameters) {
        String inputValue = this.input.replace(parameters);
        if (!Item.checkReq(this.isRequired, inputValue)) {
            return null;
        }
        try {
            JSONParser parser = new JSONParser();
            Parameters subParams = parameters.copy();
            subParams.putObject("json", parser.parse(inputValue));
            String outputValue = this.output.replace(subParams);
            if (!Item.checkReq(this.isRequired, outputValue)) {
                return null;
            }
            return outputValue;
        }
        catch (NumberFormatException | ParseException ex) {
            LOGGER.warning("Error parsing JSON: " + ex);
            return null;
        }
    }

    @Override
    public Set<String> getIdentifiersWithPrefix(String prefix) {
        return Item.getIdentifiersWithPrefix(prefix, this.input, this.output);
    }

    @Override
    public Set<String> getRequiredIdentifiers() {
        return Item.getRequiredIdentifiers(this.isRequired, this.input, this.output);
    }

    public String toString() {
        return String.format("JSON %s/%s", this.input, this.output);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Json other = (Json)obj;
        if (this.isRequired != other.isRequired) {
            return false;
        }
        if (!Objects.equals(this.input, other.input)) {
            return false;
        }
        return Objects.equals(this.output, other.output);
    }

    public int hashCode() {
        int hash = 3;
        hash = 67 * hash + (this.isRequired ? 1 : 0);
        hash = 67 * hash + Objects.hashCode(this.input);
        hash = 67 * hash + Objects.hashCode(this.output);
        return hash;
    }
}

