/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.commands;

import chatty.util.Pair;
import chatty.util.StringUtil;
import chatty.util.commands.CustomCommand;
import chatty.util.commands.Item;
import chatty.util.commands.Parameters;
import chatty.util.commands.StringReader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

class JsonPathItem
implements Item {
    private static final Logger LOGGER = Logger.getLogger(JsonPathItem.class.getName());
    private final boolean isRequired;
    private final Item path;
    private final Item def;
    private final List<Pair<Item, Boolean>> subItems;

    public JsonPathItem(Item path, Item def, List<Pair<Item, Boolean>> subItems, boolean isRequired) {
        this.path = path;
        this.def = def;
        this.subItems = subItems;
        this.isRequired = isRequired;
    }

    @Override
    public String replace(Parameters parameters) {
        String resultText;
        Object result;
        String value = this.path.replace(parameters);
        if (!Item.checkReq(this.isRequired, value)) {
            return null;
        }
        Object data = parameters.getObject("json");
        if (data == null) {
            LOGGER.warning("No JSON object");
            return null;
        }
        try {
            result = new Parser(value).parse().resolve(data);
        }
        catch (ParseException ex) {
            String msg = CustomCommand.makeErrorMessage(ex.getLocalizedMessage(), ex.getErrorOffset(), value, false);
            LOGGER.warning("Error parsing $j(): " + msg);
            return null;
        }
        for (Pair<Item, Boolean> subItemData : this.subItems) {
            Parameters modifiedParameters = parameters.copy();
            Item subItem = (Item)subItemData.key;
            boolean each = (Boolean)subItemData.value;
            if (each) {
                JSONArray arrayResult = new JSONArray();
                if (result instanceof JSONObject) {
                    JSONObject map = (JSONObject)result;
                    for (Object key : map.keySet()) {
                        modifiedParameters.put("key", String.valueOf(key));
                        modifiedParameters.putObject("json", map.get(key));
                        String itemResult = subItem.replace(modifiedParameters);
                        if (itemResult == null) {
                            return null;
                        }
                        arrayResult.add(itemResult);
                    }
                } else if (result instanceof JSONArray) {
                    JSONArray array = (JSONArray)result;
                    for (int i = 0; i < array.size(); ++i) {
                        modifiedParameters.put("index", String.valueOf(i));
                        modifiedParameters.putObject("json", array.get(i));
                        String itemResult = subItem.replace(modifiedParameters);
                        if (itemResult == null) {
                            return null;
                        }
                        arrayResult.add(itemResult);
                    }
                }
                result = arrayResult;
                continue;
            }
            modifiedParameters.putObject("json", result);
            result = subItem.replace(modifiedParameters);
        }
        String string = resultText = result == null ? "" : String.valueOf(result);
        if (resultText.isEmpty() && this.def != null) {
            resultText = this.def.replace(parameters);
        }
        if (!Item.checkReq(this.isRequired, resultText)) {
            return null;
        }
        return resultText;
    }

    public String toString() {
        return "JsonPath " + this.path + "/" + this.def;
    }

    @Override
    public Set<String> getIdentifiersWithPrefix(String prefix) {
        HashSet<String> result = new HashSet<String>();
        for (Pair<Item, Boolean> item : this.subItems) {
            result.addAll(Item.getIdentifiersWithPrefix(prefix, item.key));
        }
        result.addAll(Item.getIdentifiersWithPrefix(prefix, this.path, this.def));
        return result;
    }

    @Override
    public Set<String> getRequiredIdentifiers() {
        HashSet<String> result = new HashSet<String>();
        for (Pair<Item, Boolean> item : this.subItems) {
            result.addAll(Item.getRequiredIdentifiers(this.isRequired, item.key));
        }
        result.addAll(Item.getRequiredIdentifiers(this.isRequired, this.path, this.def));
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JsonPathItem other = (JsonPathItem)obj;
        if (this.isRequired != other.isRequired) {
            return false;
        }
        if (!Objects.equals(this.path, other.path)) {
            return false;
        }
        if (!Objects.equals(this.def, other.def)) {
            return false;
        }
        return Objects.equals(this.subItems, other.subItems);
    }

    public int hashCode() {
        int hash = 5;
        hash = 11 * hash + (this.isRequired ? 1 : 0);
        hash = 11 * hash + Objects.hashCode(this.path);
        hash = 11 * hash + Objects.hashCode(this.def);
        hash = 11 * hash + Objects.hashCode(this.subItems);
        return hash;
    }

    private static class Parser {
        private final StringReader reader;

        public Parser(String text) {
            this.reader = new StringReader(text);
        }

        PathItem parse() throws ParseException {
            return this.parse(null);
        }

        private PathItem parse(String to) throws ParseException {
            TopItem result = new TopItem();
            while (this.reader.hasNext() && (to == null || !this.reader.peek().matches(to))) {
                if (this.reader.accept("[")) {
                    result.keyFinished();
                    result.add(this.bracketsItem());
                    continue;
                }
                if (this.reader.accept("->")) {
                    if (result.keyFinished()) continue;
                    continue;
                }
                result.addToKey(this.reader.next());
            }
            result.keyFinished();
            return result;
        }

        private PathItem bracketsItem() throws ParseException {
            String name;
            PathItem result = null;
            String number = this.readAll("[0-9]");
            if (!number.isEmpty()) {
                result = new IndexItem(Integer.parseInt(number));
            }
            if (result == null && !(name = this.readAll("[a-z]")).isEmpty()) {
                switch (name) {
                    case "last": {
                        result = new IndexItem(-1);
                        break;
                    }
                    case "unique": 
                    case "size": 
                    case "sort": {
                        result = new FuncItem(name);
                        break;
                    }
                    case "filter": 
                    case "collect": 
                    case "combine": {
                        this.expect(":");
                        try {
                            result = this.filterItem(name);
                        }
                        catch (PatternSyntaxException ex) {
                            this.error("Invalid regex (" + ex.getLocalizedMessage() + ")", 0);
                        }
                        break;
                    }
                    case "join": {
                        String delimiter = ", ";
                        if (this.accept(":")) {
                            delimiter = this.param();
                        }
                        result = new JoinItem(delimiter);
                    }
                }
            }
            if (result == null) {
                this.error("Invalid [ ] content", 0);
            }
            this.expect("]");
            return result;
        }

        private PathItem filterItem(String type) throws ParseException {
            PathItem path = this.parse("[]=]");
            String search = null;
            if (this.accept("=")) {
                search = this.param();
            }
            return new FilterItem(type, path, search);
        }

        private String param() throws ParseException {
            if (this.accept("'")) {
                return this.quotedLiteral("'");
            }
            return this.readAll("[^]]");
        }

        private void error(String message, int offset) throws ParseException {
            throw new ParseException(message, this.reader.pos() + offset);
        }

        private boolean accept(String text) {
            return this.reader.accept(text);
        }

        private void expect(String character) throws ParseException {
            if (!this.reader.hasNext() || !this.reader.next().equals(character)) {
                this.error("Expected '" + character + "'", 0);
            }
        }

        private String readAll(String regex) {
            StringBuilder b = new StringBuilder();
            while (this.reader.hasNext() && this.reader.peek().matches(regex)) {
                b.append(this.reader.next());
            }
            return b.toString();
        }

        private String quotedLiteral(String quote) throws ParseException {
            StringBuilder b = new StringBuilder();
            while (this.reader.hasNext()) {
                if (this.reader.peek().equals(quote)) {
                    this.reader.next();
                    if (!this.reader.hasNext() || !this.reader.peek().equals(quote)) break;
                    b.append(this.reader.next());
                    continue;
                }
                b.append(this.reader.next());
            }
            return b.toString();
        }
    }

    private static interface PathItem {
        public Object resolve(Object var1);
    }

    private static class FilterItem
    implements PathItem {
        private final String type;
        private final PathItem path;
        private final Pattern search;

        public FilterItem(String type, PathItem path, String search) {
            this.type = type;
            this.path = path;
            this.search = search != null ? Pattern.compile(search) : null;
        }

        @Override
        public Object resolve(Object data) {
            if (data instanceof JSONArray) {
                JSONArray array = (JSONArray)data;
                JSONArray result = new JSONArray();
                for (Object o : array) {
                    this.makeResult(o, result);
                }
                return result;
            }
            if (data instanceof JSONObject) {
                JSONObject object = (JSONObject)data;
                JSONArray result = new JSONArray();
                for (Object key : object.keySet()) {
                    Object o = object.get(key);
                    this.makeResult(o, result);
                }
                return result;
            }
            return null;
        }

        private void makeResult(Object o, JSONArray result) {
            Object value = this.path.resolve(o);
            if (value != null && (this.search == null || this.search.matcher(String.valueOf(value)).matches())) {
                switch (this.type) {
                    case "filter": {
                        result.add(o);
                        break;
                    }
                    case "collect": {
                        result.add(value);
                    }
                }
            }
            if (this.type.equals("combine") && value instanceof JSONArray && value instanceof JSONArray) {
                for (Object item : (JSONArray)value) {
                    if (item == null || this.search != null && !this.search.matcher(String.valueOf(item)).matches()) continue;
                    result.add(item);
                }
            }
        }
    }

    private static class JoinItem
    implements PathItem {
        private final String delimiter;

        public JoinItem(String delimiter) {
            this.delimiter = delimiter;
        }

        @Override
        public Object resolve(Object data) {
            if (data instanceof JSONArray) {
                JSONArray array = (JSONArray)data;
                return StringUtil.join(array, this.delimiter);
            }
            return null;
        }
    }

    private static class FuncItem
    implements PathItem {
        private final String key;

        public FuncItem(String key) {
            this.key = key;
        }

        @Override
        public Object resolve(Object data) {
            switch (this.key) {
                case "size": {
                    if (data instanceof JSONArray) {
                        return ((JSONArray)data).size();
                    }
                    if (data instanceof JSONObject) {
                        return ((JSONObject)data).size();
                    }
                    if (!(data instanceof String)) break;
                    return ((String)data).length();
                }
                case "unique": {
                    if (!(data instanceof JSONArray)) break;
                    JSONArray result = new JSONArray();
                    result.addAll(new LinkedHashSet((JSONArray)data));
                    return result;
                }
                case "sort": {
                    if (!(data instanceof JSONArray)) break;
                    JSONArray result = new JSONArray();
                    result.addAll((JSONArray)data);
                    try {
                        Collections.sort(result);
                    }
                    catch (Exception ex) {
                        return null;
                    }
                    return result;
                }
            }
            return null;
        }
    }

    private static class KeyItem
    implements PathItem {
        private final String key;

        public KeyItem(String key) {
            this.key = key;
        }

        @Override
        public Object resolve(Object data) {
            if (data instanceof JSONObject) {
                JSONObject object = (JSONObject)data;
                return object.get(this.key);
            }
            return null;
        }
    }

    private static class IndexItem
    implements PathItem {
        private final int index;

        public IndexItem(int index) {
            this.index = index;
        }

        @Override
        public Object resolve(Object data) {
            if (data instanceof JSONArray) {
                try {
                    JSONArray array = (JSONArray)data;
                    if (this.index == -1) {
                        return array.get(array.size() - 1);
                    }
                    return array.get(this.index);
                }
                catch (IndexOutOfBoundsException ex) {
                    return null;
                }
            }
            return null;
        }
    }

    private static class TopItem
    implements PathItem {
        private final List<PathItem> items = new ArrayList<PathItem>();
        private StringBuilder key = new StringBuilder();

        private TopItem() {
        }

        public void add(PathItem item) {
            this.items.add(item);
        }

        public void addToKey(String text) {
            this.key.append(text);
        }

        public boolean keyFinished() {
            if (this.key.length() > 0) {
                this.add(new KeyItem(this.key.toString()));
                this.key = new StringBuilder();
                return true;
            }
            return false;
        }

        @Override
        public Object resolve(Object data) {
            if (data == null) {
                return null;
            }
            for (PathItem item : this.items) {
                data = item.resolve(data);
            }
            return data;
        }
    }
}

