/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.commands;

import chatty.util.StringUtil;
import chatty.util.commands.Item;
import chatty.util.commands.Parameters;
import java.util.Objects;
import java.util.Set;

class Lower
implements Item {
    private final boolean isRequired;
    private final Item identifier;

    public Lower(Item identifier, boolean isRequired) {
        this.identifier = identifier;
        this.isRequired = isRequired;
    }

    @Override
    public String replace(Parameters parameters) {
        String value = this.identifier.replace(parameters);
        if (!Item.checkReq(this.isRequired, value)) {
            return null;
        }
        return StringUtil.toLowerCase(value);
    }

    public String toString() {
        return "Lower " + this.identifier;
    }

    @Override
    public Set<String> getIdentifiersWithPrefix(String prefix) {
        return Item.getIdentifiersWithPrefix(prefix, this.identifier);
    }

    @Override
    public Set<String> getRequiredIdentifiers() {
        return Item.getRequiredIdentifiers(this.isRequired, this.identifier);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Lower other = (Lower)obj;
        if (this.isRequired != other.isRequired) {
            return false;
        }
        return Objects.equals(this.identifier, other.identifier);
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + (this.isRequired ? 1 : 0);
        hash = 79 * hash + Objects.hashCode(this.identifier);
        return hash;
    }
}

