/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.commands;

import chatty.Room;
import chatty.User;
import chatty.util.DateTime;
import chatty.util.StringUtil;
import chatty.util.api.StreamInfo;
import chatty.util.api.usericons.Usericon;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class Parameters {
    private final Map<String, String> parameters;
    private String[] args;
    private final Map<String, Object> objectParameters = new HashMap<String, Object>();

    public Parameters(Map<String, String> parameters) {
        this.parameters = parameters;
        this.updateArgs();
    }

    public synchronized Parameters copy() {
        Parameters result = new Parameters(new HashMap<String, String>(this.parameters));
        result.objectParameters.putAll(this.objectParameters);
        return result;
    }

    public synchronized String get(String key) {
        String result = this.parameters.get(key);
        if (result == null) {
            result = Parameters.getUserParameter(key, (User)this.getObject("user"));
        }
        if (result == null && key.startsWith("my-")) {
            result = Parameters.getUserParameter(key.substring("my-".length()), (User)this.getObject("localUser"));
        }
        if (result == null) {
            result = Parameters.getStreamInfoParameter(key, (StreamInfo)this.getObject("streamInfo"));
        }
        return result;
    }

    public synchronized boolean hasKey(String key) {
        return this.get(key) != null;
    }

    public synchronized boolean notEmpty(String ... keys) {
        for (String key : keys) {
            if (!StringUtil.isNullOrEmpty(this.get(key))) continue;
            return false;
        }
        return true;
    }

    public synchronized boolean notEmpty(Collection<String> keys) {
        for (String key : keys) {
            if (!StringUtil.isNullOrEmpty(this.get(key))) continue;
            return false;
        }
        return true;
    }

    public synchronized Object getObject(String key) {
        return this.objectParameters.get(key);
    }

    public synchronized void put(String key, String value) {
        if (key != null && value != null && !value.isEmpty()) {
            this.parameters.put(key, value);
            if (key.equals("args")) {
                this.updateArgs();
            }
        }
    }

    public synchronized void remove(String key) {
        if (key != null) {
            this.parameters.remove(key);
            if (key.equals("args")) {
                this.updateArgs();
            }
        }
    }

    public synchronized void putObject(String key, Object value) {
        if (key != null && value != null) {
            this.objectParameters.put(key, value);
        }
    }

    public synchronized void putArgs(String args) {
        this.parameters.put("args", args);
        this.updateArgs();
    }

    public synchronized String getArgs() {
        return this.parameters.get("args");
    }

    private void updateArgs() {
        this.args = this.parameters.get("args") != null ? this.parameters.get("args").split(" ") : new String[0];
    }

    public synchronized Collection<String> getRange(int startIndex, boolean toEnd) {
        if (startIndex > this.args.length - 1) {
            return null;
        }
        LinkedList<String> result = new LinkedList<String>();
        if (!toEnd) {
            result.add(this.args[startIndex]);
        } else {
            for (int i = startIndex; i < this.args.length; ++i) {
                result.add(this.args[i]);
            }
        }
        return result;
    }

    public static Parameters create(String args) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("args", args);
        return new Parameters(parameters);
    }

    public synchronized String toString() {
        return this.parameters.toString();
    }

    private static String getUserParameter(String name, User user) {
        if (user == null) {
            return null;
        }
        switch (name) {
            case "nick": {
                return user.getRegularDisplayNick();
            }
            case "user-id": {
                return user.getId();
            }
            case "display-nick": {
                return user.getDisplayNick();
            }
            case "custom-nick": {
                return user.getCustomNick();
            }
            case "full-nick": {
                return user.getFullNick();
            }
            case "special-nick": {
                return !user.hasRegularDisplayNick() ? "true" : null;
            }
        }
        if (user.hasRegularDisplayNick()) {
            switch (name) {
                case "display-nick2": {
                    return user.getDisplayNick();
                }
                case "full-nick2": {
                    return user.getFullNick();
                }
            }
        } else {
            switch (name) {
                case "display-nick2": {
                    return user.getDisplayNick() + " (" + user.getRegularDisplayNick() + ")";
                }
                case "full-nick2": {
                    return user.getFullNick() + " (" + user.getRegularDisplayNick() + ")";
                }
            }
        }
        if (user.getTwitchBadges() != null) {
            switch (name) {
                case "twitch-badge-info": {
                    return user.getTwitchBadges().toString();
                }
                case "twitch-badges": {
                    return Usericon.makeBadgeInfo(user.getTwitchBadges());
                }
            }
        }
        if (user.getRoom() != null) {
            Room room = user.getRoom();
            switch (name) {
                case "user-channel": {
                    return room.getChannel();
                }
                case "user-stream": {
                    return room.getStream();
                }
                case "user-stream-id": {
                    return room.getStreamId();
                }
            }
        }
        return null;
    }

    private static String getStreamInfoParameter(String name, StreamInfo streamInfo) {
        if (streamInfo == null || !streamInfo.isValid() || !name.startsWith("stream")) {
            return null;
        }
        switch (name) {
            case "streamstatus": {
                return streamInfo.getFullStatus();
            }
            case "streamname": {
                return streamInfo.getCapitalizedName();
            }
            case "streamdisplayname": {
                return streamInfo.getDisplayName();
            }
            case "streamdisplayname2": {
                return streamInfo.hasRegularDisplayName() ? streamInfo.getDisplayName() : String.format("%s (%s)", streamInfo.getDisplayName(), streamInfo.getCapitalizedName());
            }
            case "streamid": {
                return streamInfo.getBroadcastId();
            }
        }
        if (streamInfo.getOnline()) {
            switch (name) {
                case "streamuptime": {
                    return DateTime.agoUptimeCompact2(streamInfo.getTimeStartedWithPicnic());
                }
                case "streamuptime2": {
                    return DateTime.agoUptimeCompact2(streamInfo.getTimeStarted());
                }
                case "streamseconds": {
                    return String.valueOf(TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - streamInfo.getTimeStarted()));
                }
                case "streamtitle": {
                    return streamInfo.getTitle();
                }
                case "streamgame": {
                    return streamInfo.getGame();
                }
                case "streamviewers": {
                    return String.valueOf(streamInfo.getViewers());
                }
            }
        }
        return null;
    }
}

