/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.commands;

import chatty.util.Pair;
import chatty.util.SyntaxHighlighter;
import chatty.util.commands.Calc;
import chatty.util.commands.DateTime;
import chatty.util.commands.Escape;
import chatty.util.commands.Get;
import chatty.util.commands.Identifier;
import chatty.util.commands.If;
import chatty.util.commands.IfEq;
import chatty.util.commands.Input;
import chatty.util.commands.Is;
import chatty.util.commands.Item;
import chatty.util.commands.Items;
import chatty.util.commands.Join;
import chatty.util.commands.Json;
import chatty.util.commands.JsonPathItem;
import chatty.util.commands.Literal;
import chatty.util.commands.Lower;
import chatty.util.commands.Quote;
import chatty.util.commands.Rand;
import chatty.util.commands.RandNum;
import chatty.util.commands.RangeIdentifier;
import chatty.util.commands.Replace;
import chatty.util.commands.Replacement;
import chatty.util.commands.Request;
import chatty.util.commands.Round;
import chatty.util.commands.Sort;
import chatty.util.commands.SpecialEscape;
import chatty.util.commands.StringReader;
import chatty.util.commands.Switch;
import chatty.util.commands.Trim;
import chatty.util.commands.Upper;
import chatty.util.commands.UrlEncode;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Parser {
    private final String input;
    private final StringReader reader;
    private String escape = "\\";
    private String special = "$";
    private SyntaxHighlighter syntaxHighlighter;
    private static final String QUOTES = "[\"`']";

    public Parser(String text, String special, String escape) {
        this.input = text;
        this.reader = new StringReader(text);
        this.special = special;
        this.escape = escape;
    }

    Items parse(SyntaxHighlighter syntaxHighlighter) throws ParseException {
        this.syntaxHighlighter = syntaxHighlighter;
        return this.parse();
    }

    Items parse() throws ParseException {
        if (this.special.length() > 1 || this.escape.length() > 1) {
            this.error("Special/escape must each be a single character", 0);
        }
        if (this.special.equals(this.escape) && !this.escape.isEmpty()) {
            this.error("Special and escape must not be equal", 0);
        }
        return this.parse((String)null);
    }

    private Items parse(String to) throws ParseException {
        Items items = new Items();
        while (this.reader.hasNext() && (to == null || !this.reader.peek().matches(to))) {
            if (this.accept(this.special)) {
                Item item = this.specialThing();
                if (to == null) {
                    items.add(new SpecialEscape(item));
                    continue;
                }
                items.add(item);
                continue;
            }
            if (this.accept(this.escape)) {
                if (!this.reader.hasNext()) continue;
                items.add(this.reader.next());
                continue;
            }
            items.add(this.reader.next());
        }
        items.flush();
        return items;
    }

    private void startHl(int offset, SyntaxHighlighter.Type type) {
        if (this.syntaxHighlighter != null) {
            this.syntaxHighlighter.start(this.reader.pos() + offset, type);
        }
    }

    private void endHl() {
        if (this.syntaxHighlighter != null) {
            this.syntaxHighlighter.end(this.reader.pos() + 1);
        }
    }

    private void addHl(String character) {
        if (this.syntaxHighlighter == null || "$".contains(character)) {
            return;
        }
        if ("-".contains(character)) {
            this.syntaxHighlighter.add(this.reader.pos(), this.reader.pos() + 1, SyntaxHighlighter.Type.IDENTIFIER);
        } else if (character.equals("\\")) {
            this.syntaxHighlighter.add(this.reader.pos(), this.reader.pos() + 1, SyntaxHighlighter.Type.ESCAPE);
        } else {
            this.syntaxHighlighter.add(this.reader.pos(), this.reader.pos() + 1, SyntaxHighlighter.Type.REGULAR2);
        }
    }

    private void error(String message, int offset) throws ParseException {
        throw new ParseException(message, this.reader.pos() + offset);
    }

    private boolean accept(String character) {
        if (this.reader.hasNext() && this.reader.peek().equals(character)) {
            this.reader.next();
            this.addHl(character);
            return true;
        }
        return false;
    }

    private boolean peek(String character) {
        return this.reader.hasNext() && this.reader.peek().equals(character);
    }

    private String acceptMatch(String regex) {
        if (this.reader.hasNext() && this.reader.peek().matches(regex)) {
            return this.reader.next();
        }
        return null;
    }

    private void expect(String character) throws ParseException {
        if (!this.reader.hasNext() || !this.reader.next().equals(character)) {
            this.error("Expected '" + character + "'", 0);
        }
        this.addHl(character);
    }

    private String readAll(String regex) {
        StringBuilder b = new StringBuilder();
        while (this.reader.hasNext() && this.reader.peek().matches(regex)) {
            b.append(this.reader.next());
        }
        return b.toString();
    }

    private String readOne(String regex) {
        if (this.reader.hasNext() && this.reader.peek().matches(regex)) {
            return this.reader.next();
        }
        return "";
    }

    private Item specialThing() throws ParseException {
        String quote = this.acceptMatch(QUOTES);
        if (quote != null) {
            this.startHl(-1, SyntaxHighlighter.Type.ESCAPE);
            return this.literal(quote);
        }
        this.startHl(0, SyntaxHighlighter.Type.REGULAR);
        boolean isRequired = this.accept(this.special);
        String type = this.functionName();
        this.endHl();
        if (type.isEmpty()) {
            return this.replacement(isRequired);
        }
        if (type.equals("if")) {
            return this.condition(isRequired);
        }
        if (type.equals("join")) {
            return this.join(isRequired);
        }
        if (type.equals("ifeq")) {
            return this.ifEq(isRequired);
        }
        if (type.equals("switch")) {
            return this.switchFunc(isRequired);
        }
        if (type.equals("lower")) {
            return this.lower(isRequired);
        }
        if (type.equals("upper")) {
            return this.upper(isRequired);
        }
        if (type.equals("trim")) {
            return this.trim(isRequired);
        }
        if (type.equals("rand")) {
            return this.rand(isRequired);
        }
        if (type.equals("randnum")) {
            return this.randNum(isRequired);
        }
        if (type.equals("datetime")) {
            return this.datetime(isRequired);
        }
        if (type.equals("urlencode")) {
            return this.urlencode(isRequired);
        }
        if (type.equals("cs")) {
            return this.escape(Escape.Type.CHAIN, isRequired);
        }
        if (type.equals("fs")) {
            return this.escape(Escape.Type.FOREACH, isRequired);
        }
        if (type.equals("sort")) {
            return this.sort(isRequired);
        }
        if (type.equals("replace")) {
            return this.replace(isRequired);
        }
        if (type.equals("is")) {
            return this.is(isRequired);
        }
        if (type.equals("get")) {
            return this.get(isRequired);
        }
        if (type.equals("calc")) {
            return this.calc(isRequired);
        }
        if (type.equals("round")) {
            return this.round(isRequired);
        }
        if (type.equals("input")) {
            return this.input(isRequired);
        }
        if (type.equals("request")) {
            return this.request(isRequired);
        }
        if (type.equals("json")) {
            return this.json(isRequired);
        }
        if (type.equals("j")) {
            return this.jsonPath(isRequired);
        }
        if (type.equals("quote")) {
            return this.quote(isRequired);
        }
        this.error("Invalid function '" + type + "'", 0);
        return null;
    }

    private Item identifier() throws ParseException {
        Matcher m;
        this.startHl(1, SyntaxHighlighter.Type.IDENTIFIER);
        String ref = this.readAll("[a-zA-Z0-9-_]");
        if (ref.isEmpty()) {
            this.error("Expected identifier", 1);
        }
        if ((m = Pattern.compile("([0-9]+)(-)?").matcher(ref)).matches()) {
            int index = Integer.parseInt(m.group(1));
            if (index == 0) {
                this.error("Invalid numeric identifier 0", 0);
            }
            boolean toEnd = m.group(2) != null;
            this.endHl();
            return new RangeIdentifier(index, toEnd);
        }
        this.endHl();
        return new Identifier(ref);
    }

    private Item tinyIdentifier() throws ParseException {
        int index;
        this.startHl(1, SyntaxHighlighter.Type.IDENTIFIER);
        String ref = this.readOne("[0-9]");
        this.endHl();
        if (ref.isEmpty()) {
            this.error("Expected numeric identifier", 1);
        }
        if ((index = Integer.parseInt(ref)) == 0) {
            this.error("Invalid numeric identifer 0", 0);
        }
        boolean toEnd = false;
        if (this.accept("-")) {
            toEnd = true;
        }
        return new RangeIdentifier(index, toEnd);
    }

    private Item condition(boolean isRequired) throws ParseException {
        this.expect("(");
        Item identifier = this.peekParam();
        this.expect(",");
        Items output1 = this.param();
        Items output2 = null;
        if (this.accept(",")) {
            output2 = this.lastParam();
        }
        this.expect(")");
        return new If(identifier, isRequired, output1, output2);
    }

    private Item ifEq(boolean isRequired) throws ParseException {
        this.expect("(");
        Item identifier = this.peekParam();
        this.expect(",");
        Items compare = this.param();
        this.expect(",");
        Items output1 = this.param();
        Items output2 = null;
        if (this.accept(",")) {
            output2 = this.lastParam();
        }
        this.expect(")");
        return new IfEq(identifier, isRequired, compare, output1, output2);
    }

    private Item switchFunc(boolean isRequired) throws ParseException {
        this.expect("(");
        Item identifier = this.peekParam();
        Items def = new Items();
        this.expect(",");
        LinkedHashMap<Item, Item> cases = new LinkedHashMap<Item, Item>();
        do {
            Items key = this.parse("[,):]");
            if (this.accept(":")) {
                if (cases.containsKey(key)) {
                    this.error("Duplicate case: " + key, 0);
                }
            } else {
                def = key;
                break;
            }
            cases.put(key, this.param());
        } while (this.accept(","));
        this.expect(")");
        if (cases.isEmpty()) {
            this.error("No case found", -1);
        }
        return new Switch(identifier, cases, def, isRequired);
    }

    private Item join(boolean isRequired) throws ParseException {
        this.expect("(");
        Item identifier = this.peekParam();
        this.expect(",");
        Items separator = this.parse("[)]");
        if (separator.isEmpty()) {
            this.error("Expected separator string", 1);
        }
        this.expect(")");
        return new Join(identifier, separator, isRequired);
    }

    private Item lower(boolean isRequired) throws ParseException {
        this.expect("(");
        Item identifier = this.peekParam();
        this.expect(")");
        return new Lower(identifier, isRequired);
    }

    private Item upper(boolean isRequired) throws ParseException {
        this.expect("(");
        Item identifier = this.peekParam();
        this.expect(")");
        return new Upper(identifier, isRequired);
    }

    private Item trim(boolean isRequired) throws ParseException {
        this.expect("(");
        Items identifier = this.param();
        this.expect(")");
        return new Trim(identifier, isRequired);
    }

    private Item rand(boolean isRequired) throws ParseException {
        this.expect("(");
        ArrayList<Item> params = new ArrayList<Item>();
        do {
            params.add(this.param());
        } while (this.accept(","));
        this.expect(")");
        return new Rand(isRequired, params);
    }

    private Item randNum(boolean isRequired) throws ParseException {
        this.expect("(");
        Items a = this.param();
        Items b = null;
        if (this.accept(",")) {
            b = this.param();
        }
        this.expect(")");
        return new RandNum(isRequired, a, b);
    }

    private Item datetime(boolean isRequired) throws ParseException {
        this.expect("(");
        Items format = this.param();
        Items timezone = null;
        Items locale = null;
        Items timestamp = null;
        if (this.accept(",")) {
            timezone = this.param();
        }
        if (this.accept(",")) {
            locale = this.param();
        }
        if (this.accept(",")) {
            timestamp = this.param();
        }
        this.expect(")");
        return new DateTime(format, timezone, locale, timestamp, isRequired);
    }

    private Item urlencode(boolean isRequired) throws ParseException {
        this.expect("(");
        Items item = this.param();
        this.expect(")");
        return new UrlEncode(item, isRequired);
    }

    private Item escape(Escape.Type type, boolean isRequired) throws ParseException {
        this.expect("(");
        Items item = this.param();
        this.expect(")");
        return new Escape(item, type, isRequired);
    }

    private Item sort(boolean isRequired) throws ParseException {
        this.expect("(");
        Items item = this.param();
        Items type = null;
        if (this.accept(",")) {
            type = this.param();
        }
        Items sep = null;
        if (this.accept(",")) {
            sep = this.param();
        }
        this.expect(")");
        return new Sort(item, sep, type, isRequired);
    }

    private Item replace(boolean isRequired) throws ParseException {
        this.expect("(");
        Items item = this.midParam();
        this.expect(",");
        Items search = this.midParam();
        this.expect(",");
        Items replace = this.param();
        Items type = null;
        if (this.accept(",")) {
            type = this.param();
        }
        this.expect(")");
        return new Replace(item, search, replace, isRequired, type);
    }

    private Item is(boolean isRequired) throws ParseException {
        this.expect("(");
        Items item = this.param();
        this.expect(")");
        return new Is(item, isRequired);
    }

    private Item get(boolean isRequired) throws ParseException {
        this.expect("(");
        Items item = this.param();
        Items item2 = null;
        if (this.accept(",")) {
            item2 = this.param();
        }
        this.expect(")");
        return new Get(item, item2, isRequired);
    }

    private Item calc(boolean isRequired) throws ParseException {
        this.expect("(");
        Items item = this.param();
        this.expect(")");
        return new Calc(item, isRequired);
    }

    private Item round(boolean isRequired) throws ParseException {
        this.expect("(");
        Items item = this.param();
        Items decimals = null;
        Items roundingMode = null;
        Items minDecimals = null;
        if (this.accept(",")) {
            decimals = this.param();
        }
        if (this.accept(",")) {
            roundingMode = this.param();
        }
        if (this.accept(",")) {
            minDecimals = this.param();
        }
        this.expect(")");
        return new Round(item, decimals, roundingMode, minDecimals, isRequired);
    }

    private Item input(boolean isRequired) throws ParseException {
        this.expect("(");
        Items message = this.param();
        Items initial = null;
        Items type = null;
        if (this.accept(",")) {
            initial = this.param();
        }
        if (this.accept(",")) {
            type = this.param();
        }
        this.expect(")");
        return new Input(type, message, initial, isRequired);
    }

    private Item request(boolean isRequired) throws ParseException {
        this.expect("(");
        Items url = this.param();
        ArrayList<Item> options = new ArrayList<Item>();
        if (this.accept(",")) {
            do {
                options.add(this.param());
            } while (this.accept(","));
        }
        this.expect(")");
        return new Request(url, options, isRequired);
    }

    private Item json(boolean isRequired) throws ParseException {
        this.expect("(");
        Items input = this.param();
        this.expect(",");
        Items output = this.param();
        this.expect(")");
        return new Json(input, output, isRequired);
    }

    private Item jsonPath(boolean isRequired) throws ParseException {
        this.expect("(");
        Items path = this.param();
        Items def = null;
        if (this.accept(",")) {
            def = this.param();
        }
        ArrayList<Pair<Item, Boolean>> subItems = new ArrayList<Pair<Item, Boolean>>();
        while (this.accept(",")) {
            boolean each = false;
            if (this.reader.accept("each:")) {
                each = true;
            }
            subItems.add(new Pair<Items, Boolean>(this.param(), each));
        }
        this.expect(")");
        return new JsonPathItem(path, def, subItems, isRequired);
    }

    private Item quote(boolean isRequired) throws ParseException {
        this.expect("(");
        Items input = this.param();
        Items quote = null;
        if (this.accept(",")) {
            quote = this.param();
        }
        this.expect(")");
        return new Quote(input, quote, isRequired);
    }

    private Replacement replacement(boolean isRequired) throws ParseException {
        if (this.accept("(")) {
            Item identifier = this.identifier();
            Items args = null;
            if (this.accept(",")) {
                args = this.param();
            }
            this.expect(")");
            return new Replacement(identifier, args, isRequired);
        }
        Item identifier = this.tinyIdentifier();
        return new Replacement(identifier, null, isRequired);
    }

    private Item literal(String quote) throws ParseException {
        StringBuilder b = new StringBuilder();
        this.endHl();
        while (this.reader.hasNext()) {
            if (this.reader.peek().equals(quote)) {
                this.reader.next();
                if (!this.reader.hasNext() || !this.reader.peek().equals(quote)) break;
                b.append(this.reader.next());
                continue;
            }
            b.append(this.reader.next());
        }
        if (this.reader.last().matches(QUOTES)) {
            this.addHl("\\");
        }
        return new Literal(b.toString());
    }

    private Item changedEscapeCharacter(String escapeCharacter) throws ParseException {
        String quote = this.acceptMatch(QUOTES);
        if (quote == null) {
            this.error("Expected one of: [\"`']", 1);
        }
        String currentEscape = this.escape;
        this.escape = escapeCharacter;
        Items result = this.parse(quote);
        this.expect(quote);
        this.escape = currentEscape;
        return result;
    }

    private String functionName() {
        return this.readAll("[a-zA-Z]");
    }

    private Items param() throws ParseException {
        return this.parse("[,)]");
    }

    private Items midParam() throws ParseException {
        return this.parse("[,]");
    }

    private Items lastParam() throws ParseException {
        return this.parse("[)]");
    }

    private Item peekParam() throws ParseException {
        return this.peek("$") ? this.param() : this.identifier();
    }

    public static void main(String[] args) {
        Identifier id = new Identifier("abc");
        Literal lit = new Literal("abcd");
        Items items = new Items();
        items.add(id);
        items.add(new Identifier("aijofwe"));
        items.add("_ffweffabc");
        items.add(new Join(new Identifier("cheese"), null, true));
        System.out.println(Item.getIdentifiersWithPrefix("_", id, lit, items));
    }
}

