/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.commands;

import chatty.util.StringUtil;
import chatty.util.commands.Item;
import chatty.util.commands.Parameters;
import java.util.Objects;
import java.util.Set;

public class Quote
implements Item {
    private final boolean isRequired;
    private final Item input;
    private final Item quote;

    public Quote(Item input, Item quote, boolean isRequired) {
        this.input = input;
        this.quote = quote;
        this.isRequired = isRequired;
    }

    @Override
    public String replace(Parameters parameters) {
        String value = this.input.replace(parameters);
        if (!Item.checkReq(this.isRequired, value)) {
            return null;
        }
        String quoteValue = "\"";
        if (this.quote != null) {
            quoteValue = this.quote.replace(parameters);
            if (!Item.checkReq(this.isRequired, quoteValue)) {
                return null;
            }
        }
        return StringUtil.quote(value, quoteValue);
    }

    @Override
    public Set<String> getIdentifiersWithPrefix(String prefix) {
        return Item.getIdentifiersWithPrefix(prefix, this.input, this.quote);
    }

    @Override
    public Set<String> getRequiredIdentifiers() {
        return Item.getRequiredIdentifiers(this.isRequired, this.input, this.quote);
    }

    public String toString() {
        if (this.quote != null) {
            return "Quote(" + this.quote + ") " + this.input;
        }
        return "Quote " + this.input;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Quote other = (Quote)obj;
        if (this.isRequired != other.isRequired) {
            return false;
        }
        if (!Objects.equals(this.input, other.input)) {
            return false;
        }
        return Objects.equals(this.quote, other.quote);
    }

    public int hashCode() {
        int hash = 5;
        hash = 97 * hash + (this.isRequired ? 1 : 0);
        hash = 97 * hash + Objects.hashCode(this.input);
        hash = 97 * hash + Objects.hashCode(this.quote);
        return hash;
    }
}

