/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.commands;

import chatty.util.commands.Item;
import chatty.util.commands.Parameters;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;

public class Rand
implements Item {
    private final boolean isRequired;
    private final List<Item> params;

    public Rand(boolean isRequired, List<Item> params) {
        this.isRequired = isRequired;
        this.params = params;
    }

    @Override
    public String replace(Parameters parameters) {
        Item random = this.params.get(ThreadLocalRandom.current().nextInt(0, this.params.size()));
        String replaced = random.replace(parameters);
        if (!Item.checkReq(this.isRequired, replaced)) {
            return null;
        }
        return replaced;
    }

    @Override
    public Set<String> getIdentifiersWithPrefix(String prefix) {
        return Item.getIdentifiersWithPrefix(prefix, this.params);
    }

    @Override
    public Set<String> getRequiredIdentifiers() {
        return Item.getRequiredIdentifiers(this.isRequired, this.params);
    }

    public String toString() {
        return "Rand " + this.params;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Rand other = (Rand)obj;
        if (this.isRequired != other.isRequired) {
            return false;
        }
        return Objects.equals(this.params, other.params);
    }

    public int hashCode() {
        int hash = 7;
        hash = 73 * hash + (this.isRequired ? 1 : 0);
        hash = 73 * hash + Objects.hashCode(this.params);
        return hash;
    }
}

