/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.commands;

import chatty.util.commands.Item;
import chatty.util.commands.Parameters;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;

public class RandNum
implements Item {
    private final boolean isRequired;
    private final Item a;
    private final Item b;

    public RandNum(boolean isRequired, Item a, Item b) {
        this.isRequired = isRequired;
        this.a = a;
        this.b = b;
    }

    @Override
    public String replace(Parameters parameters) {
        int bound;
        int origin = 0;
        if (this.b == null) {
            String valueA = this.a.replace(parameters);
            if (!Item.checkReq(this.isRequired, valueA)) {
                return null;
            }
            bound = RandNum.parseInt(valueA, 0x7FFFFFFE);
        } else {
            String valueA = this.a.replace(parameters);
            String valueB = this.b.replace(parameters);
            if (!Item.checkReq(this.isRequired, valueA, valueB)) {
                return null;
            }
            origin = RandNum.parseInt(valueA, 0);
            bound = RandNum.parseInt(valueB, 0x7FFFFFFE);
        }
        try {
            return String.valueOf(ThreadLocalRandom.current().nextInt(origin, bound + 1));
        }
        catch (Exception ex) {
            return "0";
        }
    }

    @Override
    public Set<String> getIdentifiersWithPrefix(String prefix) {
        return Item.getIdentifiersWithPrefix(prefix, this.a, this.b);
    }

    @Override
    public Set<String> getRequiredIdentifiers() {
        return Item.getRequiredIdentifiers(this.isRequired, this.a, this.b);
    }

    public String toString() {
        if (this.b == null) {
            return "RandNum 0 to " + this.a;
        }
        return "RandNum " + this.a + " to " + this.b;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RandNum other = (RandNum)obj;
        if (this.isRequired != other.isRequired) {
            return false;
        }
        if (!Objects.equals(this.a, other.a)) {
            return false;
        }
        return Objects.equals(this.b, other.b);
    }

    public int hashCode() {
        int hash = 7;
        hash = 11 * hash + (this.isRequired ? 1 : 0);
        hash = 11 * hash + Objects.hashCode(this.a);
        hash = 11 * hash + Objects.hashCode(this.b);
        return hash;
    }

    private static int parseInt(String input, int fallback) {
        try {
            return Integer.parseInt(input);
        }
        catch (NumberFormatException ex) {
            return fallback;
        }
    }
}

