/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.commands;

import chatty.util.StringUtil;
import chatty.util.commands.Item;
import chatty.util.commands.Parameters;
import java.util.Collection;
import java.util.Set;

class RangeIdentifier
implements Item {
    private final int index;
    private final boolean toEnd;

    public RangeIdentifier(int index, boolean toEnd) {
        this.index = index;
        this.toEnd = toEnd;
    }

    @Override
    public String replace(Parameters parameters) {
        Collection<String> range = parameters.getRange(this.index - 1, this.toEnd);
        if (range == null) {
            return "";
        }
        return StringUtil.join(range, " ");
    }

    public String toString() {
        return "$" + this.index + (this.toEnd ? "-" : "");
    }

    @Override
    public Set<String> getIdentifiersWithPrefix(String prefix) {
        return null;
    }

    @Override
    public Set<String> getRequiredIdentifiers() {
        return null;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RangeIdentifier other = (RangeIdentifier)obj;
        if (this.index != other.index) {
            return false;
        }
        return this.toEnd == other.toEnd;
    }

    public int hashCode() {
        int hash = 5;
        hash = 37 * hash + this.index;
        hash = 37 * hash + (this.toEnd ? 1 : 0);
        return hash;
    }
}

