/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.commands;

import chatty.util.StringUtil;
import chatty.util.commands.CustomCommand;
import chatty.util.commands.Item;
import chatty.util.commands.Parameters;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Replace
implements Item {
    private final boolean isRequired;
    private final Item item;
    private final Item search;
    private final Item replace;
    private final Item type;

    public Replace(Item item, Item search, Item replace, boolean isRequired, Item type) {
        this.item = item;
        this.search = search;
        this.replace = replace;
        this.isRequired = isRequired;
        this.type = type;
    }

    @Override
    public String replace(Parameters parameters) {
        String result;
        String replaceValue;
        String searchValue;
        String itemValue = this.item.replace(parameters);
        if (!Item.checkReq(false, itemValue, searchValue = this.search.replace(parameters), replaceValue = this.replace.replace(parameters))) {
            return null;
        }
        String typeValue = "";
        if (this.type != null && (typeValue = this.type.replace(parameters)) == null) {
            return null;
        }
        try {
            switch (typeValue) {
                case "reg": {
                    result = itemValue.replaceAll(searchValue, Matcher.quoteReplacement(replaceValue));
                    break;
                }
                case "regFirst": {
                    result = itemValue.replaceFirst(searchValue, Matcher.quoteReplacement(replaceValue));
                    break;
                }
                case "regRef": {
                    result = itemValue.replaceAll(searchValue, replaceValue);
                    break;
                }
                case "regFirstRef": {
                    result = itemValue.replaceFirst(searchValue, replaceValue);
                    break;
                }
                case "regFunc": 
                case "regCustom": {
                    String typeValue2 = typeValue;
                    result = StringUtil.replaceFunc(itemValue, searchValue, m -> {
                        Parameters replaceParameters = parameters.copy();
                        replaceParameters.putArgs(m.group());
                        for (int i = 1; i <= m.groupCount(); ++i) {
                            replaceParameters.put("g" + i, m.group(i));
                        }
                        if (typeValue2.equals("regFunc")) {
                            CustomCommand c = (CustomCommand)parameters.getObject(replaceValue);
                            if (c != null) {
                                return c.replace(replaceParameters);
                            }
                            return "";
                        }
                        return this.replace.replace(replaceParameters);
                    });
                    break;
                }
                case "cs": {
                    result = itemValue.replace(searchValue, replaceValue);
                    break;
                }
                default: {
                    result = itemValue.replaceAll("(?iu)" + Pattern.quote(searchValue), Matcher.quoteReplacement(replaceValue));
                    break;
                }
            }
        }
        catch (Exception ex) {
            return "Error: " + ex.getLocalizedMessage();
        }
        if (!Item.checkReq(this.isRequired, result)) {
            return null;
        }
        return result;
    }

    public String toString() {
        return String.format("Replace %s with %s in %s via %s", this.search, this.replace, this.item, this.type == null ? "default" : this.type);
    }

    @Override
    public Set<String> getIdentifiersWithPrefix(String prefix) {
        return Item.getIdentifiersWithPrefix(prefix, this.item, this.search, this.replace);
    }

    @Override
    public Set<String> getRequiredIdentifiers() {
        return Item.getRequiredIdentifiers(this.isRequired, this.item, this.search, this.replace);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Replace other = (Replace)obj;
        if (this.isRequired != other.isRequired) {
            return false;
        }
        if (!Objects.equals(this.item, other.item)) {
            return false;
        }
        if (!Objects.equals(this.search, other.search)) {
            return false;
        }
        if (!Objects.equals(this.replace, other.replace)) {
            return false;
        }
        return Objects.equals(this.type, other.type);
    }

    public int hashCode() {
        int hash = 3;
        hash = 11 * hash + (this.isRequired ? 1 : 0);
        hash = 11 * hash + Objects.hashCode(this.item);
        hash = 11 * hash + Objects.hashCode(this.search);
        hash = 11 * hash + Objects.hashCode(this.replace);
        hash = 11 * hash + Objects.hashCode(this.type);
        return hash;
    }
}

