/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.commands;

import chatty.util.commands.Item;
import chatty.util.commands.Parameters;
import java.util.Objects;
import java.util.Set;

class Replacement
implements Item {
    private final boolean isRequired;
    private final Item identifier;
    private final Item args;

    public Replacement(Item name, Item args, boolean isRequired) {
        this.identifier = name;
        this.isRequired = isRequired;
        this.args = args;
    }

    @Override
    public String replace(Parameters parameters) {
        String value;
        if (this.args != null) {
            String argsValue = this.args.replace(parameters);
            if (argsValue == null) {
                return null;
            }
            parameters = parameters.copy();
            parameters.putArgs(argsValue);
        }
        if ((value = this.identifier.replace(parameters)) != null && !value.isEmpty()) {
            return value;
        }
        return this.isRequired ? null : "";
    }

    public String toString() {
        return (this.isRequired ? "$" : "") + this.identifier.toString();
    }

    @Override
    public Set<String> getIdentifiersWithPrefix(String prefix) {
        return this.identifier.getIdentifiersWithPrefix(prefix);
    }

    @Override
    public Set<String> getRequiredIdentifiers() {
        return Item.getRequiredIdentifiers(this.isRequired, this.identifier);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Replacement other = (Replacement)obj;
        if (!Objects.equals(this.identifier, other.identifier)) {
            return false;
        }
        return this.isRequired == other.isRequired;
    }

    public int hashCode() {
        int hash = 5;
        hash = 97 * hash + (this.isRequired ? 1 : 0);
        hash = 97 * hash + Objects.hashCode(this.identifier);
        return hash;
    }
}

