/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.commands;

import chatty.util.UrlRequest;
import chatty.util.commands.Item;
import chatty.util.commands.Parameters;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Request
implements Item {
    private final boolean isRequired;
    private final Item url;
    private final List<Item> options;

    Request(Item url, List<Item> options, boolean isRequired) {
        this.url = url;
        this.options = options;
        this.isRequired = isRequired;
    }

    @Override
    public String replace(Parameters parameters) {
        String urlString = this.url.replace(parameters);
        if (!Item.checkReq(this.isRequired, urlString)) {
            return null;
        }
        ArrayList<String> optionsString = new ArrayList<String>();
        for (Item option : this.options) {
            String optionString = option.replace(parameters);
            if (!Item.checkReq(this.isRequired, optionString)) {
                return null;
            }
            optionsString.add(optionString);
        }
        boolean outputError = optionsString.contains("error");
        boolean trim = optionsString.contains("trim");
        if (parameters.get("allow-request") == null) {
            return outputError ? "Request not allowed in this context" : this.error();
        }
        if (!urlString.startsWith("http://") && !urlString.startsWith("https://")) {
            return outputError ? "URL scheme must be http or https" : this.error();
        }
        try {
            UrlRequest request = new UrlRequest(urlString);
            for (String option : optionsString) {
                Matcher m = Pattern.compile("h\\[(?<key>[^:]+): (?<value>.+)\\]").matcher(option);
                if (!m.matches()) continue;
                request.setRequestProperty(m.group("key"), m.group("value"));
            }
            request.setLabel("Custom Command");
            UrlRequest.FullResult result = request.sync();
            String resultText = result.getResult();
            if (resultText == null) {
                if (outputError) {
                    if (result.getResponseCode() != 0) {
                        return "Request error: " + result.getResponseCode();
                    }
                    return "Request error: " + result.getError();
                }
                return this.error();
            }
            if (resultText.isEmpty() && this.isRequired) {
                return null;
            }
            return trim ? resultText.trim() : resultText;
        }
        catch (Exception ex) {
            return outputError ? ex.getClass().getSimpleName() + ": " + ex.getLocalizedMessage() : this.error();
        }
    }

    private String error() {
        if (this.isRequired) {
            return null;
        }
        return "";
    }

    @Override
    public Set<String> getIdentifiersWithPrefix(String prefix) {
        if (prefix.equals("-async-")) {
            return Item.getIdentifiersWithPrefix(prefix, this.url, this.options, "-async-");
        }
        return Item.getIdentifiersWithPrefix(prefix, this.url, this.options);
    }

    @Override
    public Set<String> getRequiredIdentifiers() {
        return Item.getRequiredIdentifiers(this.isRequired, this.url, this.options);
    }

    public String toString() {
        return "Request " + this.url + "(" + this.options + ")";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Request other = (Request)obj;
        if (this.isRequired != other.isRequired) {
            return false;
        }
        if (!Objects.equals(this.url, other.url)) {
            return false;
        }
        return Objects.equals(this.options, other.options);
    }

    public int hashCode() {
        int hash = 7;
        hash = 47 * hash + (this.isRequired ? 1 : 0);
        hash = 47 * hash + Objects.hashCode(this.url);
        hash = 47 * hash + Objects.hashCode(this.options);
        return hash;
    }
}

