/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.commands;

import chatty.util.commands.Item;
import chatty.util.commands.Parameters;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;

public class Round
implements Item {
    private final boolean isRequired;
    private final Item input;
    private final Item decimalsItem;
    private final Item roundingModeItem;
    private final Item minDecimalsItem;

    public Round(Item input, Item decimals, Item roundingMode, Item minDecimals, boolean isRequired) {
        this.input = input;
        this.decimalsItem = decimals;
        this.roundingModeItem = roundingMode;
        this.minDecimalsItem = minDecimals;
        this.isRequired = isRequired;
    }

    @Override
    public String replace(Parameters parameters) {
        double num;
        String numString = this.input.replace(parameters);
        if (!Item.checkReq(this.isRequired, numString)) {
            return null;
        }
        try {
            num = Double.parseDouble(numString);
        }
        catch (NumberFormatException ex) {
            return numString;
        }
        int decimals = this.getInt(this.decimalsItem, parameters);
        if (decimals == -1) {
            return null;
        }
        int minDecimals = this.getInt(this.minDecimalsItem, parameters);
        if (minDecimals == -1) {
            return null;
        }
        String roundingMode = "";
        if (this.roundingModeItem != null) {
            roundingMode = this.roundingModeItem.replace(parameters);
            if (!Item.checkReq(this.isRequired, roundingMode)) {
                return null;
            }
        }
        return Round.round(num, decimals, Round.getRoundingMode(roundingMode), minDecimals);
    }

    private int getInt(Item item, Parameters parameters) {
        if (item == null) {
            return 0;
        }
        String temp = item.replace(parameters);
        if (!Item.checkReq(this.isRequired, temp)) {
            return -1;
        }
        try {
            return Integer.parseInt(temp);
        }
        catch (NumberFormatException ex) {
            return 0;
        }
    }

    private static RoundingMode getRoundingMode(String input) {
        switch (input) {
            case "floor": {
                return RoundingMode.FLOOR;
            }
            case "ceil": {
                return RoundingMode.CEILING;
            }
            case "up": {
                return RoundingMode.UP;
            }
            case "down": {
                return RoundingMode.DOWN;
            }
            case "half-down": {
                return RoundingMode.HALF_DOWN;
            }
        }
        return RoundingMode.HALF_UP;
    }

    public static String round(double input, int decimals, RoundingMode mode, int minDecials) {
        DecimalFormat format = new DecimalFormat("#.####################", DecimalFormatSymbols.getInstance(Locale.ROOT));
        format.setMinimumFractionDigits(minDecials);
        return format.format(BigDecimal.valueOf(input).setScale(decimals, mode));
    }

    public String toString() {
        return String.format("Round %s(%s/%s/%s)", this.input, Round.opt(this.decimalsItem), Round.opt(this.roundingModeItem), Round.opt(this.minDecimalsItem));
    }

    private static String opt(Object item) {
        return item != null ? item.toString() : "-";
    }

    @Override
    public Set<String> getIdentifiersWithPrefix(String prefix) {
        return Item.getIdentifiersWithPrefix(prefix, this.input, this.decimalsItem, this.roundingModeItem);
    }

    @Override
    public Set<String> getRequiredIdentifiers() {
        return Item.getRequiredIdentifiers(this.isRequired, this.input, this.decimalsItem, this.roundingModeItem);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Round other = (Round)obj;
        if (this.isRequired != other.isRequired) {
            return false;
        }
        if (!Objects.equals(this.input, other.input)) {
            return false;
        }
        if (!Objects.equals(this.decimalsItem, other.decimalsItem)) {
            return false;
        }
        if (!Objects.equals(this.roundingModeItem, other.roundingModeItem)) {
            return false;
        }
        return Objects.equals(this.minDecimalsItem, other.minDecimalsItem);
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + (this.isRequired ? 1 : 0);
        hash = 97 * hash + Objects.hashCode(this.input);
        hash = 97 * hash + Objects.hashCode(this.decimalsItem);
        hash = 97 * hash + Objects.hashCode(this.roundingModeItem);
        hash = 97 * hash + Objects.hashCode(this.minDecimalsItem);
        return hash;
    }
}

