/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.commands;

import chatty.util.StringUtil;
import chatty.util.commands.Item;
import chatty.util.commands.Parameters;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;

class Sort
implements Item {
    private final Item item;
    private final Item separator;
    private final Item type;
    private final boolean isRequired;

    public Sort(Item item, Item separator, Item type, boolean isRequired) {
        this.item = item;
        this.separator = separator;
        this.type = type;
        this.isRequired = isRequired;
    }

    @Override
    public String replace(Parameters parameters) {
        String value = this.item.replace(parameters);
        if (!Item.checkReq(this.isRequired, value)) {
            return null;
        }
        String sep = " ";
        if (this.separator != null && (sep = this.separator.replace(parameters)) == null) {
            return null;
        }
        String t = "abc";
        if (this.type != null && (t = this.type.replace(parameters)) == null) {
            return null;
        }
        List<String> split = Arrays.asList(value.split(Pattern.quote(sep)));
        switch (t) {
            case "abc": {
                Collections.sort(split, String.CASE_INSENSITIVE_ORDER);
                break;
            }
            case "Abc": {
                Collections.sort(split);
            }
        }
        return StringUtil.join(split, sep);
    }

    public String toString() {
        return "Sort " + this.item + "/" + this.separator;
    }

    @Override
    public Set<String> getIdentifiersWithPrefix(String prefix) {
        return Item.getIdentifiersWithPrefix(prefix, this.item, this.separator, this.type);
    }

    @Override
    public Set<String> getRequiredIdentifiers() {
        return Item.getRequiredIdentifiers(this.isRequired, this.item, this.separator, this.type);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Sort other = (Sort)obj;
        if (!Objects.equals(this.item, other.item)) {
            return false;
        }
        if (!Objects.equals(this.separator, other.separator)) {
            return false;
        }
        if (!Objects.equals(this.type, other.type)) {
            return false;
        }
        return this.isRequired == other.isRequired;
    }

    public int hashCode() {
        int hash = 7;
        hash = 83 * hash + Objects.hashCode(this.item);
        hash = 83 * hash + Objects.hashCode(this.separator);
        hash = 83 * hash + Objects.hashCode(this.type);
        hash = 83 * hash + (this.isRequired ? 1 : 0);
        return hash;
    }
}

