/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.commands;

import chatty.Helper;
import chatty.util.Debugging;
import chatty.util.commands.Item;
import chatty.util.commands.Parameters;
import java.util.Objects;
import java.util.Set;

public class SpecialEscape
implements Item {
    private final Item item;

    SpecialEscape(Item item) {
        this.item = item;
    }

    @Override
    public String replace(Parameters parameters) {
        String result = this.item.replace(parameters);
        if (parameters.get(Helper.ESCAPE_FOR_CHAIN_COMMAND) != null && result != null) {
            result = Helper.escapeForChainCommand(result);
        }
        if (parameters.get(Helper.ESCAPE_FOR_FOREACH_COMMAND) != null && result != null) {
            result = Helper.escapeForForeachCommand(result);
        }
        return result;
    }

    @Override
    public Set<String> getIdentifiersWithPrefix(String prefix) {
        return this.item.getIdentifiersWithPrefix(prefix);
    }

    @Override
    public Set<String> getRequiredIdentifiers() {
        return this.item.getRequiredIdentifiers();
    }

    public String toString() {
        if (Debugging.isEnabled("cc-tli")) {
            return "{" + this.item.toString() + "}";
        }
        return this.item.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SpecialEscape other = (SpecialEscape)obj;
        return Objects.equals(this.item, other.item);
    }

    public int hashCode() {
        int hash = 7;
        hash = 47 * hash + Objects.hashCode(this.item);
        return hash;
    }
}

