/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.commands;

public class StringReader {
    private final String string;
    private int index = -1;

    public StringReader(String string) {
        this.string = string;
    }

    public boolean hasNext() {
        return this.string.length() > this.index + 1;
    }

    public String next() {
        ++this.index;
        return this.string.substring(this.index, this.index + 1);
    }

    public String peek() {
        return this.string.substring(this.index + 1, this.index + 2);
    }

    public String peek(int amount) {
        if (this.string.length() > this.index + amount) {
            return this.string.substring(this.index + 1, this.index + amount + 1);
        }
        return "";
    }

    public boolean accept(String text) {
        if (this.peek(text.length()).equals(text)) {
            this.index += text.length();
            return true;
        }
        return false;
    }

    public String last() {
        return this.string.substring(this.index, this.index + 1);
    }

    public int pos() {
        return this.index;
    }

    public static void main(String[] args) {
        StringReader reader = new StringReader("abc");
        System.out.println(reader.next());
        System.out.println(reader.peek());
        System.out.println(reader.next());
        System.out.println(reader.next());
        System.out.println(reader.next());
    }
}

