/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.commands;

import chatty.util.commands.Item;
import chatty.util.commands.Parameters;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class Switch
implements Item {
    private final Item param;
    private final Map<Item, Item> cases;
    private final Item def;
    private final boolean isRequired;

    public Switch(Item param, Map<Item, Item> cases, Item def, boolean isRequired) {
        this.param = param;
        this.cases = cases;
        this.def = def;
        this.isRequired = isRequired;
    }

    @Override
    public String replace(Parameters parameters) {
        String ref = this.param.replace(parameters);
        if (!Item.checkReq(this.isRequired, ref)) {
            return null;
        }
        Item resultItem = null;
        for (Map.Entry<Item, Item> entry : this.cases.entrySet()) {
            String caseString = entry.getKey().replace(parameters);
            if (!Objects.equals(caseString, ref)) continue;
            resultItem = entry.getValue();
            break;
        }
        if (resultItem == null) {
            resultItem = this.def;
        }
        String result = resultItem.replace(parameters);
        return Item.checkReq(this.isRequired, result) ? result : null;
    }

    public String toString() {
        return "Switch " + this.param + "/" + this.cases + "/" + this.def;
    }

    @Override
    public Set<String> getIdentifiersWithPrefix(String prefix) {
        return Item.getIdentifiersWithPrefix(prefix, this.getAllParams());
    }

    @Override
    public Set<String> getRequiredIdentifiers() {
        return Item.getRequiredIdentifiers(this.isRequired, this.getAllParams());
    }

    private Object[] getAllParams() {
        ArrayList<Item> result = new ArrayList<Item>();
        result.addAll(this.cases.keySet());
        result.addAll(this.cases.values());
        result.add(this.param);
        result.add(this.def);
        return result.toArray();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Switch other = (Switch)obj;
        if (!Objects.equals(this.param, other.param)) {
            return false;
        }
        if (!Objects.equals(this.cases, other.cases)) {
            return false;
        }
        if (!Objects.equals(this.def, other.def)) {
            return false;
        }
        return this.isRequired == other.isRequired;
    }

    public int hashCode() {
        int hash = 5;
        hash = 71 * hash + Objects.hashCode(this.param);
        hash = 71 * hash + Objects.hashCode(this.cases);
        hash = 71 * hash + Objects.hashCode(this.def);
        hash = 71 * hash + (this.isRequired ? 1 : 0);
        return hash;
    }
}

