/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.commands;

import chatty.util.StringUtil;
import chatty.util.commands.Item;
import chatty.util.commands.Parameters;
import java.util.Objects;
import java.util.Set;

public class Trim
implements Item {
    private final boolean isRequired;
    private final Item input;

    public Trim(Item identifier, boolean isRequired) {
        this.input = identifier;
        this.isRequired = isRequired;
    }

    @Override
    public String replace(Parameters parameters) {
        String value = this.input.replace(parameters);
        if (!Item.checkReq(this.isRequired, value)) {
            return null;
        }
        return StringUtil.trim(value);
    }

    public String toString() {
        return "Trim " + this.input;
    }

    @Override
    public Set<String> getIdentifiersWithPrefix(String prefix) {
        return Item.getIdentifiersWithPrefix(prefix, this.input);
    }

    @Override
    public Set<String> getRequiredIdentifiers() {
        return Item.getRequiredIdentifiers(this.isRequired, this.input);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Trim other = (Trim)obj;
        if (this.isRequired != other.isRequired) {
            return false;
        }
        return Objects.equals(this.input, other.input);
    }

    public int hashCode() {
        int hash = 5;
        hash = 19 * hash + (this.isRequired ? 1 : 0);
        hash = 19 * hash + Objects.hashCode(this.input);
        return hash;
    }
}

