/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.commands;

import chatty.util.commands.Item;
import chatty.util.commands.Parameters;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;

class Upper
implements Item {
    private final boolean isRequired;
    private final Item identifier;

    public Upper(Item identifier, boolean isRequired) {
        this.identifier = identifier;
        this.isRequired = isRequired;
    }

    @Override
    public String replace(Parameters parameters) {
        String value = this.identifier.replace(parameters);
        if (!Item.checkReq(this.isRequired, value)) {
            return null;
        }
        return value.toUpperCase(Locale.ENGLISH);
    }

    public String toString() {
        return "Upper " + this.identifier;
    }

    @Override
    public Set<String> getIdentifiersWithPrefix(String prefix) {
        return Item.getIdentifiersWithPrefix(prefix, this.identifier);
    }

    @Override
    public Set<String> getRequiredIdentifiers() {
        return Item.getRequiredIdentifiers(this.isRequired, this.identifier);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Upper other = (Upper)obj;
        if (this.isRequired != other.isRequired) {
            return false;
        }
        return Objects.equals(this.identifier, other.identifier);
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + (this.isRequired ? 1 : 0);
        hash = 31 * hash + Objects.hashCode(this.identifier);
        return hash;
    }
}

