/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.commands;

import chatty.util.commands.Item;
import chatty.util.commands.Parameters;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Objects;
import java.util.Set;

class UrlEncode
implements Item {
    private final Item item;
    private final boolean isRequired;

    public UrlEncode(Item item, boolean isRequired) {
        this.item = item;
        this.isRequired = isRequired;
    }

    @Override
    public String replace(Parameters parameters) {
        String value = this.item.replace(parameters);
        if (!Item.checkReq(this.isRequired, value)) {
            return null;
        }
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public String toString() {
        return "UrlEncode " + this.item;
    }

    @Override
    public Set<String> getIdentifiersWithPrefix(String prefix) {
        return Item.getIdentifiersWithPrefix(prefix, this.item);
    }

    @Override
    public Set<String> getRequiredIdentifiers() {
        return Item.getRequiredIdentifiers(this.isRequired, this.item);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UrlEncode other = (UrlEncode)obj;
        if (!Objects.equals(this.item, other.item)) {
            return false;
        }
        return this.isRequired == other.isRequired;
    }

    public int hashCode() {
        int hash = 3;
        hash = 67 * hash + Objects.hashCode(this.item);
        hash = 67 * hash + (this.isRequired ? 1 : 0);
        return hash;
    }
}

