/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.dnd;

import chatty.util.dnd.DockChild;
import chatty.util.dnd.DockContent;
import chatty.util.dnd.DockDropInfo;
import chatty.util.dnd.DockImportInfo;
import chatty.util.dnd.DockLayoutElement;
import chatty.util.dnd.DockLayoutSplit;
import chatty.util.dnd.DockLayoutTabs;
import chatty.util.dnd.DockManager;
import chatty.util.dnd.DockOverlay;
import chatty.util.dnd.DockPath;
import chatty.util.dnd.DockPathEntry;
import chatty.util.dnd.DockPopout;
import chatty.util.dnd.DockSetting;
import chatty.util.dnd.DockSplit;
import chatty.util.dnd.DockTabs;
import chatty.util.dnd.DockTabsContainer;
import chatty.util.dnd.DockTransferInfo;
import chatty.util.dnd.DockTransferable;
import chatty.util.dnd.DockUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class DockBase
extends JPanel
implements DockChild {
    private final DockOverlay overlay;
    private final DockManager manager;
    private DockChild child;

    public DockBase(DockManager m) {
        this.setLayout(new BorderLayout());
        this.child = new DockTabsContainer();
        this.child.setBase(this);
        this.child.setDockParent(this);
        this.add((Component)this.child.getComponent(), "Center");
        this.overlay = new DockOverlay(this);
        this.manager = m;
    }

    @Override
    public DockDropInfo findDrop(DockImportInfo info) {
        DockDropInfo childDrop = this.child.findDrop(info);
        if (childDrop != null && childDrop.location == DockDropInfo.DropType.INVALID) {
            return null;
        }
        if (childDrop != null) {
            return childDrop;
        }
        DockDropInfo.DropType location = DockDropInfo.determineLocation(this, info.getLocation(this), 20, 80, 0);
        if (location != null && location != DockDropInfo.DropType.CENTER) {
            return new DockDropInfo(this, location, DockDropInfo.makeRect(this, location, 20, 0, 80), -1);
        }
        return childDrop;
    }

    @Override
    public void addContent(DockContent content) {
        this.child.addContent(content);
    }

    public void requestDrag(boolean allowPopout) {
        this.manager.requestDrag(allowPopout);
    }

    public void startDrag() {
        this.getRootPane().setGlassPane(this.overlay);
        this.overlay.setVisible(true);
        this.overlay.setOpaque(false);
    }

    public void requestStopDrag(DockTransferable t) {
        this.manager.requestStopDrag(t);
    }

    public void stopDrag() {
        this.overlay.setVisible(false);
        this.repaint();
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public void split(DockDropInfo info, DockContent content) {
        if (this.child.isEmpty()) {
            this.child.addContent(content);
            return;
        }
        DockTabsContainer newCompTabs = new DockTabsContainer();
        DockSplit newChildSplit = DockUtil.createSplit(info, this.child, newCompTabs);
        if (newChildSplit != null) {
            this.applySettings(newChildSplit);
            newChildSplit.setBase(this);
            newChildSplit.setDockParent(this);
            this.applySettings(newCompTabs);
            newCompTabs.setBase(this);
            newCompTabs.setDockParent(newChildSplit);
            newCompTabs.addContent(content);
            this.child.setDockParent(newChildSplit);
            this.exchangeChild(newChildSplit);
            DockSplit split = newChildSplit;
            split.setDividerLocation(0.5);
            split.setResizeWeight(0.5);
            SwingUtilities.invokeLater(() -> {
                split.setDividerLocation(0.5);
                split.setResizeWeight(0.5);
            });
        }
    }

    @Override
    public void setBase(DockBase base) {
    }

    @Override
    public void setDockParent(DockChild parent) {
    }

    @Override
    public DockChild getDockParent() {
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.child.isEmpty();
    }

    @Override
    public void removeContent(DockContent content) {
        this.child.removeContent(content);
        this.validate();
    }

    @Override
    public void drop(DockTransferInfo info) {
        info.importInfo.content.setTargetPath(null);
        info.importInfo.source.removeContent(info.importInfo.content);
        this.split(info.dropInfo, info.importInfo.content);
    }

    @Override
    public void replace(DockChild old, DockChild replacement) {
        if (replacement == null) {
            this.manager.baseEmpty(this);
            return;
        }
        if (old == this.child && old != replacement) {
            this.remove(this.child.getComponent());
            replacement.setBase(this);
            replacement.setDockParent(this);
            this.child = replacement;
            this.add((Component)this.child.getComponent(), "Center");
            this.revalidate();
        }
    }

    @Override
    public List<DockContent> getContents() {
        return this.child.getContents();
    }

    public void tabChanged(DockTabs tabs, DockContent content) {
        this.manager.changedActiveContent(content, false);
    }

    @Override
    public void setActiveContent(DockContent content) {
        this.child.setActiveContent(content);
    }

    @Override
    public boolean isContentVisible(DockContent content) {
        return this.child.isContentVisible(content);
    }

    @Override
    public List<DockContent> getContentsRelativeTo(DockContent content, int direction) {
        return this.child.getContentsRelativeTo(content, direction);
    }

    @Override
    public void setSetting(DockSetting.Type setting, Object value) {
        switch (setting) {
            case FILL_COLOR: {
                this.overlay.setFillColor(DockSetting.getColor(value));
                break;
            }
            case LINE_COLOR: {
                this.overlay.setLineColor(DockSetting.getColor(value));
            }
        }
        this.child.setSetting(setting, value);
    }

    public void applySettings(DockChild child) {
        this.manager.applySettings(child);
    }

    @Override
    public DockPath getPath() {
        return this.buildPath(new DockPath(), null);
    }

    @Override
    public DockPath buildPath(DockPath path, DockChild child) {
        String popoutId = null;
        for (DockPopout popout : this.manager.getPopouts()) {
            if (popout.getBase() != this) continue;
            popoutId = popout.getId();
        }
        path.addParent(DockPathEntry.createPopout(popoutId));
        return path;
    }

    @Override
    public String toString() {
        return "DockBase";
    }

    @Override
    public DockLayoutElement getLayoutElement() {
        return this.child.getLayoutElement();
    }

    @Override
    public void cleanUp() {
        this.child.cleanUp();
    }

    public DockChild createLayout(DockLayoutElement element, DockChild parent) {
        DockChild newChild = null;
        if (element instanceof DockLayoutSplit) {
            DockLayoutSplit s = (DockLayoutSplit)element;
            DockSplit split = new DockSplit(s.orientation);
            DockChild left = this.createLayout(s.left, split);
            DockChild right = this.createLayout(s.right, split);
            split.setChildren(left, right);
            split.setDockParent(parent);
            split.setDividerLocation(s.dividerLocation);
            split.setResizeWeight(0.5);
            newChild = split;
        } else if (element instanceof DockLayoutTabs) {
            DockLayoutTabs t = (DockLayoutTabs)element;
            DockTabsContainer tabs = new DockTabsContainer();
            tabs.setDockParent(parent);
            newChild = tabs;
        }
        if (newChild != null) {
            this.child.cleanUp();
            newChild.setBase(this);
            this.exchangeChild(newChild);
            if (parent == this) {
                this.applySettings(this.child);
                this.revalidate();
            }
        }
        return newChild;
    }

    private void exchangeChild(DockChild newChild) {
        this.remove(this.child.getComponent());
        this.child = newChild;
        this.add((Component)this.child.getComponent(), "Center");
    }

    @Override
    public void sortContent(DockContent content) {
        this.child.sortContent(content);
    }
}

