/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.dnd;

import chatty.util.dnd.DockChild;
import chatty.util.dnd.DockContent;
import chatty.util.dnd.DockManager;
import chatty.util.dnd.DockPath;
import chatty.util.dnd.DockSetting;
import chatty.util.dnd.DockTabComponent;
import java.awt.Color;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class DockContentContainer<T extends JComponent>
implements DockContent {
    private final T component;
    private String title;
    private String longTitle;
    private String id;
    private final DockManager m;
    private final Set<DockContent.DockContentPropertyListener> listeners;
    private Color foregroundColor;
    private DockChild parent;
    private DockPath targetPath;

    public DockContentContainer(String title, T component, DockManager m) {
        this.component = component;
        this.title = title;
        this.m = m;
        this.listeners = new HashSet<DockContent.DockContentPropertyListener>();
    }

    @Override
    public JComponent getComponent() {
        return this.component;
    }

    public T getContent() {
        return this.component;
    }

    public boolean isContentVisible() {
        return this.m.isContentVisible(this);
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String newTitle) {
        if (newTitle == null) {
            newTitle = "";
        }
        if (!newTitle.equals(this.title)) {
            this.title = newTitle;
            this.listeners.forEach(l -> l.propertyChanged(DockContent.DockContentPropertyListener.Property.TITLE, this));
        }
    }

    public String toString() {
        return this.getTitle() + " [" + this.getComponent() + "]";
    }

    @Override
    public JPopupMenu getContextMenu() {
        JPopupMenu menu = new JPopupMenu();
        JMenuItem item = new JMenuItem("Popout " + this.title);
        item.addActionListener(e -> this.m.popout(this, DockSetting.PopoutType.DIALOG, null, null));
        menu.add(item);
        JMenuItem item2 = new JMenuItem("Popout as window");
        item2.addActionListener(e -> this.m.popout(this, DockSetting.PopoutType.FRAME, null, null));
        menu.add(item2);
        JMenuItem closeItem = new JMenuItem("Close");
        closeItem.addActionListener(e -> this.remove());
        menu.add(closeItem);
        return menu;
    }

    @Override
    public void addListener(DockContent.DockContentPropertyListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void removeListener(DockContent.DockContentPropertyListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    @Override
    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    public void setForegroundColor(Color color) {
        if (!Objects.equals(color, this.foregroundColor)) {
            this.foregroundColor = color;
            this.listeners.forEach(l -> l.propertyChanged(DockContent.DockContentPropertyListener.Property.FOREGROUND, this));
        }
    }

    @Override
    public DockTabComponent getTabComponent() {
        return null;
    }

    @Override
    public void remove() {
        this.m.removeContent(this);
    }

    @Override
    public DockPath getPath() {
        if (this.parent != null) {
            return this.parent.buildPath(new DockPath(this), null);
        }
        return null;
    }

    @Override
    public void setTargetPath(DockPath path) {
        this.targetPath = path;
    }

    @Override
    public DockPath getTargetPath() {
        return this.targetPath;
    }

    @Override
    public void setDockParent(DockChild parent) {
        this.parent = parent;
    }

    @Override
    public boolean canPopout() {
        return true;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getLongTitle() {
        return this.longTitle;
    }

    @Override
    public void setLongTitle(String title) {
        if (!Objects.equals(this.longTitle, title)) {
            this.longTitle = title;
            this.listeners.forEach(l -> l.propertyChanged(DockContent.DockContentPropertyListener.Property.LONG_TITLE, this));
        }
    }
}

