/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.dnd;

import chatty.util.dnd.DockDropInfo;
import chatty.util.dnd.DockLayoutElement;
import chatty.util.dnd.DockLayoutPopout;
import chatty.util.dnd.DockLayoutSplit;
import chatty.util.dnd.DockLayoutTabs;
import chatty.util.dnd.DockPath;
import chatty.util.dnd.DockPathEntry;
import java.util.ArrayList;
import java.util.List;

public class DockLayout {
    public final List<DockLayoutPopout> main;

    public DockLayout(List<DockLayoutPopout> main) {
        this.main = main;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Layout:\n");
        for (DockLayoutPopout p : this.main) {
            b.append(p.toString()).append("\n");
        }
        return b.toString();
    }

    public List<Object> toList() {
        ArrayList<Object> result = new ArrayList<Object>();
        for (DockLayoutPopout p : this.main) {
            result.add(p.toList());
        }
        return result;
    }

    public static DockLayout fromList(List<Object> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        ArrayList<DockLayoutPopout> result = new ArrayList<DockLayoutPopout>();
        for (Object o : list) {
            DockLayoutPopout p = DockLayoutPopout.fromList((List)o);
            result.add(p);
        }
        return new DockLayout(result);
    }

    public List<String> getContentIds() {
        ArrayList<String> result = new ArrayList<String>();
        for (DockLayoutElement dockLayoutElement : this.main) {
            result.addAll(dockLayoutElement.getContentIds());
        }
        return result;
    }

    public List<String> getActiveContentIds() {
        ArrayList<String> result = new ArrayList<String>();
        for (DockLayoutElement dockLayoutElement : this.main) {
            result.addAll(dockLayoutElement.getActiveContentIds());
        }
        return result;
    }

    public DockPath getPath(String contentId) {
        DockPath path = new DockPath();
        for (DockLayoutPopout p : this.main) {
            if (!DockLayout.fillPath(contentId, p.child, path)) continue;
            path.addParent(DockPathEntry.createPopout(p.id));
        }
        if (path.isEmpty()) {
            return null;
        }
        return path;
    }

    public DockLayoutPopout getMain() {
        for (DockLayoutPopout p : this.main) {
            if (p.id != null) continue;
            return p;
        }
        return null;
    }

    private static boolean fillPath(String contentId, DockLayoutElement e, DockPath path) {
        if (e instanceof DockLayoutTabs) {
            DockLayoutTabs tabs = (DockLayoutTabs)e;
            if (tabs.contents.contains(contentId)) {
                path.addParent(DockPathEntry.createTab(0));
                return true;
            }
        } else if (e instanceof DockLayoutSplit) {
            DockLayoutSplit split = (DockLayoutSplit)e;
            if (DockLayout.fillPath(contentId, split.left, path)) {
                path.addParent(DockPathEntry.createSplit(DockDropInfo.DropType.LEFT));
                return true;
            }
            if (DockLayout.fillPath(contentId, split.right, path)) {
                path.addParent(DockPathEntry.createSplit(DockDropInfo.DropType.RIGHT));
                return true;
            }
        }
        return false;
    }
}

