/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.dnd;

import chatty.util.dnd.DockLayoutElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class DockLayoutSplit
implements DockLayoutElement {
    public final DockLayoutElement left;
    public final DockLayoutElement right;
    public final int dividerLocation;
    public final int orientation;

    public DockLayoutSplit(DockLayoutElement left, DockLayoutElement right, int dividerLocation, int orientation) {
        this.left = left;
        this.right = right;
        this.dividerLocation = dividerLocation;
        this.orientation = orientation;
    }

    public String toString() {
        return String.format("(%s|%d|%s)", this.left, this.dividerLocation, this.right);
    }

    @Override
    public List<Object> toList() {
        ArrayList<Object> result = new ArrayList<Object>();
        result.add("s");
        result.add(this.dividerLocation);
        result.add(this.orientation);
        result.add(this.left.toList());
        result.add(this.right.toList());
        return result;
    }

    public static DockLayoutElement fromList(List<Object> list) {
        if (!Objects.equals(list.get(0), "s")) {
            return null;
        }
        int dividerLocation = ((Number)list.get(1)).intValue();
        int orientiation = ((Number)list.get(2)).intValue();
        DockLayoutElement left = DockLayoutElement.fromList((List)list.get(3));
        DockLayoutElement right = DockLayoutElement.fromList((List)list.get(4));
        return new DockLayoutSplit(left, right, dividerLocation, orientiation);
    }

    @Override
    public List<String> getContentIds() {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(this.left.getContentIds());
        result.addAll(this.right.getContentIds());
        return result;
    }

    @Override
    public List<String> getActiveContentIds() {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(this.left.getActiveContentIds());
        result.addAll(this.right.getActiveContentIds());
        return result;
    }
}

