/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.dnd;

import chatty.util.Debugging;
import chatty.util.dnd.DockBase;
import chatty.util.dnd.DockChild;
import chatty.util.dnd.DockContent;
import chatty.util.dnd.DockLayout;
import chatty.util.dnd.DockLayoutPopout;
import chatty.util.dnd.DockListener;
import chatty.util.dnd.DockPath;
import chatty.util.dnd.DockPopout;
import chatty.util.dnd.DockPopoutFrame;
import chatty.util.dnd.DockPoputDialog;
import chatty.util.dnd.DockSetting;
import chatty.util.dnd.DockTabs;
import chatty.util.dnd.DockTabsContainer;
import chatty.util.dnd.DockTransferable;
import chatty.util.dnd.DockUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class DockManager {
    private final DockBase main;
    private final DockListener listener;
    private final Set<DockPopout> popouts = new HashSet<DockPopout>();
    private final LinkedList<DockPopoutFrame> unusedFrames = new LinkedList();
    private final LinkedList<DockPoputDialog> unusedDialogs = new LinkedList();
    private DockContent currentlyActive;
    private final Map<DockPopout, DockContent> active = new HashMap<DockPopout, DockContent>();
    private final Map<String, DockPath> pathOnRemove = new HashMap<String, DockPath>();
    private final Map<DockSetting.Type, Object> settings = new HashMap<DockSetting.Type, Object>();
    private DockSetting.PopoutType popoutType = DockSetting.PopoutType.DIALOG;
    private DockSetting.PopoutType popoutTypeDrag = DockSetting.PopoutType.DIALOG;
    private List<Image> popoutIcons;
    private Frame popoutParent;
    private final PropertyChangeListener popoutParentPropertyListener;

    public DockManager(DockListener listener) {
        this.main = new DockBase(this);
        this.listener = listener;
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("focusOwner", e -> {
            Object o = e.getNewValue();
            if (o != null && o instanceof Component) {
                this.checkFocus((Component)o);
            }
        });
        this.popoutParentPropertyListener = evt -> {
            if (evt.getPropertyName().equals("alwaysOnTop")) {
                this.updateWindowsAlwaysOnTop(this.popoutParent.isAlwaysOnTop());
            }
        };
    }

    private void checkFocus(Component c) {
        if (c instanceof DockContent) {
            this.changedActiveContent((DockContent)((Object)c), true);
        } else if (c instanceof DockTabs) {
            DockTabs t = (DockTabs)c;
            DockContent content = t.getCurrentContent();
            if (content != null) {
                this.changedActiveContent(content, true);
            } else if (t.getDockParent() instanceof DockTabsContainer) {
                this.changedActiveContent(((DockTabsContainer)t.getDockParent()).getCurrentContent(), true);
            }
        } else if (c instanceof DockTabsContainer) {
            this.changedActiveContent(((DockTabsContainer)c).getCurrentContent(), true);
        } else if (c instanceof DockPopout) {
            List<DockContent> contents = ((DockPopout)((Object)c)).getBase().getContents();
            if (contents.size() == 1) {
                this.changedActiveContent(contents.get(0), true);
            }
        } else if (c.getParent() != null) {
            this.checkFocus(c.getParent());
        }
    }

    protected void changedActiveContent(DockContent content, boolean focusChange) {
        Debugging.println("dnda", "Changed active (Focus: %s): %s", focusChange, content);
        if (content == null) {
            return;
        }
        DockPopout popout = this.getPopoutFromContent(content);
        if (this.currentlyActive != content || this.active.get(popout) != content) {
            this.currentlyActive = content;
            this.active.put(popout, content);
            this.listener.activeContentChanged(popout, content, focusChange);
        }
    }

    private void removeActive(DockContent content) {
        Debugging.println("dnda", "Remove active: %s", content);
        if (this.currentlyActive == content) {
            this.currentlyActive = null;
        }
        Iterator<Map.Entry<DockPopout, DockContent>> it = this.active.entrySet().iterator();
        while (it.hasNext()) {
            if (it.next().getValue() != content) continue;
            it.remove();
        }
    }

    public DockPopout getPopoutFromContent(DockContent content) {
        Container c = content.getComponent();
        do {
            if (!((c = c.getParent()) instanceof DockBase)) continue;
            for (DockPopout popout : this.popouts) {
                if (popout.getBase() != c) continue;
                return popout;
            }
            return null;
        } while (c != null);
        return null;
    }

    public DockContent getActiveContent() {
        List<DockContent> contents;
        DockContent result = this.currentlyActive;
        if (result == null && !(contents = this.getContents()).isEmpty()) {
            result = contents.iterator().next();
        }
        return result;
    }

    public DockContent getActiveContent(DockPopout popout) {
        DockBase base;
        List<DockContent> contents;
        DockContent result = this.active.get(popout);
        if (result == null && !(contents = (base = popout == null ? this.main : popout.getBase()).getContents()).isEmpty()) {
            result = contents.iterator().next();
        }
        return result;
    }

    public JComponent getBase() {
        return this.main;
    }

    public Collection<DockPopout> getPopouts() {
        return new ArrayList<DockPopout>(this.popouts);
    }

    public List<DockContent> getContents() {
        ArrayList<DockContent> result = new ArrayList<DockContent>();
        result.addAll(this.main.getContents());
        this.popouts.forEach(w -> result.addAll(w.getBase().getContents()));
        return result;
    }

    public List<DockContent> getContents(DockPopout popout) {
        DockBase base = popout == null ? this.main : popout.getBase();
        return new ArrayList<DockContent>(base.getContents());
    }

    public Collection<DockContent> getPopoutContents() {
        ArrayList<DockContent> result = new ArrayList<DockContent>();
        this.popouts.forEach(w -> result.addAll(w.getBase().getContents()));
        return result;
    }

    public List<DockContent> getContentsRelativeTo(DockContent content, int direction) {
        ArrayList<DockContent> result = new ArrayList<DockContent>();
        result.addAll(this.main.getContentsRelativeTo(content, direction));
        this.popouts.forEach(w -> result.addAll(w.getBase().getContentsRelativeTo(content, direction)));
        return result;
    }

    public List<DockContent> getContentsRelativeTo(DockContent relativeToContent) {
        ArrayList<DockContent> result = new ArrayList<DockContent>();
        List<DockContent> before = this.getContentsRelativeTo(relativeToContent, -1);
        Collections.reverse(before);
        result.addAll(before);
        result.add(relativeToContent);
        result.addAll(this.getContentsRelativeTo(relativeToContent, 1));
        return result;
    }

    public DockContent getContentTabRelative(DockContent content, int direction) {
        List<DockContent> c = this.getContentsRelativeTo(content, direction);
        if (!c.isEmpty()) {
            return c.get(0);
        }
        c = this.getContentsRelativeTo(content, -direction);
        if (!c.isEmpty()) {
            return c.get(c.size() - 1);
        }
        return null;
    }

    public DockContent getContentTabAbsolute(DockContent content, int index) {
        List<DockContent> c = this.getContentsRelativeTo(content);
        if (index >= 0 && index < c.size()) {
            return c.get(index);
        }
        return null;
    }

    public DockContent getContentById(String id) {
        for (DockContent content : this.getContents()) {
            if (!content.getId().equals(id)) continue;
            return content;
        }
        return null;
    }

    public void addContent(DockContent content) {
        DockPath target;
        if (this.hasContent(content)) {
            return;
        }
        if (this.currentlyActive == null) {
            this.changedActiveContent(content, false);
        }
        if ((target = content.getTargetPath()) == null || target.getPopoutId() == null) {
            this.main.addContent(content);
        } else {
            boolean added = false;
            for (DockPopout p : this.popouts) {
                if (!p.getId().equals(target.getPopoutId())) continue;
                p.getBase().addContent(content);
                added = true;
            }
            if (!added) {
                content.setTargetPath(null);
                this.main.addContent(content);
            }
        }
        this.listener.contentAdded(content);
    }

    private void setTargetPath(DockContent content, DockContent target) {
        if (target == null || content.getTargetPath() != null) {
            return;
        }
        DockPath path = target.getPath();
        if (path != null) {
            content.setTargetPath(path);
        }
    }

    public void removeContent(DockContent content) {
        if (!this.hasContent(content)) {
            return;
        }
        this.pathOnRemove.put(content.getId(), content.getPath());
        this.removeActive(content);
        this.main.removeContent(content);
        this.applyToPopoutsSafe(p -> p.getBase().removeContent(content));
        this.listener.contentRemoved(content);
    }

    public DockPath getPathOnRemove(String id) {
        return this.pathOnRemove.get(id);
    }

    public boolean hasContent(DockContent content) {
        return this.getContents().contains(content);
    }

    public void setActiveContent(DockContent content) {
        this.main.setActiveContent(content);
        this.popouts.forEach(w -> w.getBase().setActiveContent(content));
        DockPopout popout = this.getPopoutFromContent(content);
        if (popout != null) {
            // empty if block
        }
        this.changedActiveContent(content, false);
    }

    protected void baseEmpty(DockBase base) {
        this.applyToPopoutsSafe(p -> {
            if (p.getBase() == base) {
                this.closePopout((DockPopout)p);
            }
        });
    }

    public boolean isMainEmpty() {
        return this.main.isEmpty();
    }

    public boolean closePopout() {
        if (this.popouts.isEmpty()) {
            return false;
        }
        this.closePopout(this.popouts.iterator().next());
        return true;
    }

    protected void requestDrag(boolean allowPopout) {
        this.main.startDrag();
        if (allowPopout) {
            for (DockPopout window : this.popouts) {
                window.getBase().startDrag();
            }
        }
    }

    protected void requestStopDrag(DockTransferable t) {
        if (!DockUtil.isMouseOverWindow() && this.popoutTypeDrag != DockSetting.PopoutType.NONE && t != null && t.content != null) {
            t.content.setTargetPath(null);
            Point location = MouseInfo.getPointerInfo().getLocation();
            this.popout(t.content, this.popoutTypeDrag, new Point(location.x - 80, location.y - 10), null);
        }
        this.main.stopDrag();
        for (DockPopout window : this.popouts) {
            window.getBase().stopDrag();
        }
    }

    public void closePopout(DockPopout popout) {
        if (popout == null || !this.popouts.contains(popout)) {
            return;
        }
        this.popouts.remove(popout);
        List<DockContent> contents = popout.getBase().getContents();
        DockContent activeInPopout = this.getActiveContent(popout);
        DockContent activeInMain = this.active.get(null);
        for (DockContent c : contents) {
            popout.getBase().removeContent(c);
            this.setTargetPath(c, activeInMain);
            this.main.addContent(c);
        }
        if (activeInPopout != null) {
            this.main.setActiveContent(activeInPopout);
        }
        this.active.remove(popout);
        popout.getWindow().setVisible(false);
        if (popout instanceof DockPoputDialog) {
            if (!this.unusedDialogs.contains((DockPoputDialog)popout)) {
                this.unusedDialogs.add((DockPoputDialog)popout);
            }
        } else if (popout instanceof DockPopoutFrame && !this.unusedFrames.contains((DockPopoutFrame)popout)) {
            this.unusedFrames.add((DockPopoutFrame)popout);
        }
        if (activeInPopout != null) {
            this.changedActiveContent(activeInPopout, false);
        }
        this.listener.popoutClosed(popout, contents);
    }

    public DockPopout popout(DockContent content) {
        return this.popout(content, this.popoutType, null, null);
    }

    public DockPopout popout(DockContent content, DockSetting.PopoutType type, Point location, Dimension size) {
        if (type == DockSetting.PopoutType.NONE || !content.canPopout()) {
            return null;
        }
        this.main.removeContent(content);
        this.applyToPopoutsSafe(p -> p.getBase().removeContent(content));
        DockPopout popout = this.getPopout(type);
        popout.getBase().addContent(content);
        this.configureWindow(popout, location, size, -1);
        popout.getWindow().setVisible(true);
        SwingUtilities.invokeLater(() -> popout.getWindow().toFront());
        this.popouts.add(popout);
        this.removeActive(content);
        this.changedActiveContent(content, false);
        this.listener.popoutOpened(popout, content);
        return popout;
    }

    private DockPopout openPopout(DockSetting.PopoutType type, Point location, Dimension size, int state) {
        DockPopout popout = this.getPopout(type);
        this.configureWindow(popout, location, size, state);
        popout.getWindow().setVisible(true);
        SwingUtilities.invokeLater(() -> popout.getWindow().toFront());
        this.popouts.add(popout);
        this.listener.popoutOpened(popout, null);
        return popout;
    }

    private void configureWindow(DockPopout popout, Point location, Dimension size, int state) {
        Window window = popout.getWindow();
        if (size != null) {
            window.setSize(size);
        } else {
            window.setSize(600, 400);
        }
        if (location != null) {
            window.setLocation(location);
        } else {
            window.setLocationByPlatform(true);
        }
        if (window instanceof Frame) {
            Frame frame = (Frame)window;
            if (state == -1) {
                state = frame.getExtendedState() & 0xFFFFFFFE;
            }
            frame.setExtendedState(state);
        }
        if (this.popoutParent != null) {
            window.setAlwaysOnTop(this.popoutParent.isAlwaysOnTop());
        }
    }

    private DockPopout getPopout(DockSetting.PopoutType type) {
        DockPopout popout = this.getUnusedPopout(type);
        if (popout == null) {
            popout = type == DockSetting.PopoutType.DIALOG ? new DockPoputDialog(this, this.popoutParent) : new DockPopoutFrame(this);
            this.applySettings(popout.getBase());
            if (this.popoutIcons != null) {
                popout.getWindow().setIconImages(this.popoutIcons);
            }
            final DockPopout popout2 = popout;
            popout.getWindow().addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    DockManager.this.listener.popoutClosing(popout2);
                }
            });
        }
        popout.setId(this.popouts);
        return popout;
    }

    private DockPopout getUnusedPopout(DockSetting.PopoutType type) {
        if (type == DockSetting.PopoutType.DIALOG) {
            return this.unusedDialogs.poll();
        }
        if (type == DockSetting.PopoutType.FRAME) {
            return this.unusedFrames.poll();
        }
        return null;
    }

    private void applyToPopoutsSafe(Consumer<DockPopout> function) {
        for (DockPopout popout : new ArrayList<DockPopout>(this.popouts)) {
            function.accept(popout);
        }
    }

    private void updateWindowsAlwaysOnTop(boolean onTop) {
        for (DockPopout p : this.popouts) {
            if (p instanceof DockPopoutFrame && ((DockPopoutFrame)p).isFixedAlwaysOnTop()) continue;
            p.getWindow().setAlwaysOnTop(onTop);
        }
    }

    public void setWindowFixedAlwaysOnTop(JFrame frame, boolean fixed) {
        for (DockPopout p : this.popouts) {
            if (!(p.getWindow() instanceof DockPopoutFrame) || p.getWindow() != frame) continue;
            ((DockPopoutFrame)p).setFixedAlwaysOnTop(fixed);
        }
        if (!fixed) {
            this.updateWindowsAlwaysOnTop(this.popoutParent.isAlwaysOnTop());
        }
    }

    public boolean isContentVisible(DockContent content) {
        if (this.main.isContentVisible(content)) {
            return true;
        }
        for (DockPopout w : this.popouts) {
            if (!w.getBase().isContentVisible(content)) continue;
            return true;
        }
        return false;
    }

    public void setSetting(DockSetting.Type setting, Object value) {
        if (setting == DockSetting.Type.POPOUT_TYPE) {
            this.popoutType = (DockSetting.PopoutType)((Object)value);
        } else if (setting == DockSetting.Type.POPOUT_TYPE_DRAG) {
            this.popoutTypeDrag = (DockSetting.PopoutType)((Object)value);
        } else if (setting == DockSetting.Type.POPOUT_ICONS) {
            List images;
            this.popoutIcons = images = (List)value;
        } else if (setting == DockSetting.Type.POPOUT_PARENT) {
            if (this.popoutParent != value) {
                if (this.popoutParent != null) {
                    this.popoutParent.removePropertyChangeListener("alwaysOnTop", this.popoutParentPropertyListener);
                }
                this.popoutParent = (Frame)value;
                this.popoutParent.addPropertyChangeListener("alwaysOnTop", this.popoutParentPropertyListener);
            }
        } else {
            this.settings.put(setting, value);
            this.main.setSetting(setting, value);
            this.popouts.forEach(w -> w.getBase().setSetting(setting, value));
        }
    }

    public void applySettings(DockChild child) {
        this.settings.forEach((type, value) -> child.setSetting((DockSetting.Type)((Object)type), value));
    }

    public DockLayout getLayout() {
        ArrayList<DockLayoutPopout> result = new ArrayList<DockLayoutPopout>();
        if (this.popoutParent != null) {
            result.add(new DockLayoutPopout(null, this.popoutParent.getLocation(), this.popoutParent.getSize(), this.popoutParent.getExtendedState(), this.main.getLayoutElement()));
        } else {
            result.add(new DockLayoutPopout(null, null, null, -1, this.main.getLayoutElement()));
        }
        for (DockPopout p : this.popouts) {
            Window w = p.getWindow();
            int state = -1;
            if (w instanceof Frame) {
                state = ((Frame)w).getExtendedState();
            }
            result.add(new DockLayoutPopout(p.getId(), w.getLocation(), w.getSize(), state, p.getBase().getLayoutElement()));
        }
        return new DockLayout(result);
    }

    public void loadLayout(DockLayout layout) {
        if (layout == null) {
            return;
        }
        List<DockContent> currentContents = this.getContents();
        currentContents.forEach(c -> c.setDockParent(null));
        this.applyToPopoutsSafe(p -> this.closePopout((DockPopout)p));
        for (DockLayoutPopout p2 : layout.main) {
            if (p2.id == null) {
                this.main.createLayout(p2.child, this.main);
                continue;
            }
            DockSetting.PopoutType type = p2.id.startsWith("d") ? DockSetting.PopoutType.DIALOG : DockSetting.PopoutType.FRAME;
            DockPopout popout = this.openPopout(type, p2.location, p2.size, p2.state);
            popout.setId(p2.id);
            popout.getBase().createLayout(p2.child, popout.getBase());
        }
        this.currentlyActive = null;
        this.active.clear();
        this.pathOnRemove.clear();
    }

    public void sortContent(DockContent content) {
        this.main.sortContent(content);
        this.popouts.forEach(w -> w.getBase().sortContent(content));
    }

    public void minimizeWindows() {
        for (DockPopout p : this.popouts) {
            if (!(p.getWindow() instanceof Frame)) continue;
            Frame frame = (Frame)p.getWindow();
            frame.setExtendedState(frame.getExtendedState() | 1);
        }
    }

    public void hideWindows() {
        for (DockPopout p : this.popouts) {
            if (!(p.getWindow() instanceof Frame)) continue;
            Frame frame = (Frame)p.getWindow();
            frame.setVisible(false);
        }
    }

    public void showHiddenWindows() {
        for (DockPopout p : this.popouts) {
            if (!(p.getWindow() instanceof Frame) || p.getWindow().isVisible()) continue;
            Frame frame = (Frame)p.getWindow();
            frame.setVisible(true);
            frame.setExtendedState(frame.getExtendedState() & 0xFFFFFFFE);
            frame.toFront();
        }
    }
}

