/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.dnd;

import chatty.util.dnd.DockBase;
import chatty.util.dnd.DockDropInfo;
import chatty.util.dnd.DockImportInfo;
import chatty.util.dnd.DockTransferInfo;
import chatty.util.dnd.DockTransferable;
import chatty.util.dnd.DockUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.TransferHandler;

public class DockOverlay
extends JPanel {
    private final DockBase base;
    private Rectangle paintRect;
    private DockDropInfo dropInfo;
    private DockImportInfo importInfo;
    private Color fillColor = new Color(64, 64, 64, 64);
    private Color lineColor = Color.DARK_GRAY;

    public DockOverlay(final DockBase base) {
        this.base = base;
        Timer timer = new Timer(100, e -> {
            if (this.paintRect != null && this.getMousePosition() == null) {
                this.paintRect = null;
                this.repaint();
            }
        });
        timer.start();
        this.setTransferHandler(new TransferHandler(){

            @Override
            public boolean canImport(TransferHandler.TransferSupport info) {
                return DockOverlay.this.updateImport(info);
            }

            @Override
            public boolean importData(TransferHandler.TransferSupport info) {
                if (this.canImport(info)) {
                    DockTransferable dtf = DockUtil.getTransferable(info);
                    DockOverlay.this.paintRect = null;
                    DockOverlay.this.repaint();
                    base.requestStopDrag(dtf);
                    try {
                        ((DockOverlay)DockOverlay.this).dropInfo.dropComponent.drop(new DockTransferInfo(DockOverlay.this.dropInfo, dtf));
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    return true;
                }
                return false;
            }
        });
    }

    public void setFillColor(Color color) {
        if (color != null) {
            this.fillColor = new Color(color.getRed(), color.getGreen(), color.getBlue(), 90);
        }
    }

    public void setLineColor(Color color) {
        if (color != null) {
            this.lineColor = new Color(color.getRed(), color.getGreen(), color.getBlue(), 180);
        }
    }

    private boolean updateImport(TransferHandler.TransferSupport info) {
        DockTransferable dtf = DockUtil.getTransferable(info);
        if (dtf == null) {
            return false;
        }
        DockImportInfo importInfoUpdated = new DockImportInfo(info, dtf);
        DockDropInfo dropInfoUpdated = this.base.findDrop(importInfoUpdated);
        if (dropInfoUpdated != null) {
            Rectangle rect = dropInfoUpdated.rect;
            this.paintRect = SwingUtilities.convertRectangle(dropInfoUpdated.dropComponent.getComponent(), rect, this);
        } else {
            this.paintRect = null;
        }
        this.dropInfo = dropInfoUpdated;
        this.importInfo = importInfoUpdated;
        this.repaint();
        return dropInfoUpdated != null;
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.paintRect != null) {
            g.setColor(this.fillColor);
            g.fillRect(this.paintRect.x, this.paintRect.y, this.paintRect.width, this.paintRect.height);
            g.setColor(this.lineColor);
            g.drawRect(this.paintRect.x, this.paintRect.y, this.paintRect.width, this.paintRect.height);
        }
        if (this.importInfo != null) {
            Graphics2D g2d = (Graphics2D)g;
            if (this.importInfo.tf.image != null && this.getMousePosition() != null) {
                Point p = this.importInfo.info.getDropLocation().getDropPoint();
                int imgHeight = this.importInfo.tf.image.getHeight(null);
                Composite origComp = g2d.getComposite();
                g2d.setComposite(AlphaComposite.getInstance(3, 0.7f));
                g.drawImage(this.importInfo.tf.image, p.x + 14, p.y - imgHeight / 3, this);
                g2d.setComposite(origComp);
            }
        }
    }
}

