/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.dnd;

import chatty.util.dnd.DockContent;
import chatty.util.dnd.DockPathEntry;
import java.util.LinkedList;
import java.util.Objects;

public class DockPath {
    private final LinkedList<DockPathEntry> list = new LinkedList();
    private final String contentId;

    public DockPath(DockContent content) {
        this.contentId = content.getId();
    }

    public DockPath() {
        this.contentId = null;
    }

    public void addParent(DockPathEntry parent) {
        this.list.addFirst(parent);
    }

    public String getPopoutId() {
        if (this.list.isEmpty() || this.list.getFirst().type != DockPathEntry.Type.POPOUT) {
            return null;
        }
        return this.list.getFirst().id;
    }

    public DockPathEntry getNext(DockPath path) {
        if (path.list.size() >= this.list.size()) {
            return null;
        }
        return this.list.get(path.list.size());
    }

    public String getContentId() {
        return this.contentId;
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public String toString() {
        return String.format("%s (%s)", this.list, this.contentId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DockPath other = (DockPath)obj;
        return Objects.equals(this.list, other.list);
    }

    public int hashCode() {
        int hash = 3;
        hash = 89 * hash + Objects.hashCode(this.list);
        return hash;
    }
}

