/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.dnd;

import chatty.util.dnd.DockDropInfo;
import java.util.Objects;

public class DockPathEntry {
    public final Type type;
    public final DockDropInfo.DropType location;
    public final int index;
    public final String id;

    private DockPathEntry(DockDropInfo.DropType location) {
        this.type = Type.SPLIT;
        this.location = location;
        this.index = -1;
        this.id = null;
    }

    private DockPathEntry(int index) {
        this.type = Type.TAB;
        this.location = null;
        this.index = index;
        this.id = null;
    }

    private DockPathEntry(String id) {
        this.type = Type.POPOUT;
        this.location = null;
        this.index = -1;
        this.id = id;
    }

    public static DockPathEntry createSplit(DockDropInfo.DropType location) {
        return new DockPathEntry(location);
    }

    public static DockPathEntry createTab(int index) {
        return new DockPathEntry(index);
    }

    public static DockPathEntry createPopout(String popoutId) {
        return new DockPathEntry(popoutId);
    }

    public String toString() {
        switch (this.type) {
            case POPOUT: {
                return String.format("%s (%s)", new Object[]{this.type, this.id});
            }
            case SPLIT: {
                return String.format("%s (%s)", new Object[]{this.type, this.location});
            }
            case TAB: {
                return String.format("%s (%s)", new Object[]{this.type, this.index});
            }
        }
        return "?";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DockPathEntry other = (DockPathEntry)obj;
        if (this.index != other.index) {
            return false;
        }
        if (!Objects.equals(this.id, other.id)) {
            return false;
        }
        if (this.type != other.type) {
            return false;
        }
        return this.location == other.location;
    }

    public int hashCode() {
        int hash = 5;
        hash = 89 * hash + Objects.hashCode((Object)this.type);
        hash = 89 * hash + Objects.hashCode((Object)this.location);
        hash = 89 * hash + this.index;
        hash = 89 * hash + Objects.hashCode(this.id);
        return hash;
    }

    public static enum Type {
        SPLIT,
        TAB,
        POPOUT;

    }
}

