/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.dnd;

import chatty.util.Debugging;
import chatty.util.dnd.DockBase;
import chatty.util.dnd.DockChild;
import chatty.util.dnd.DockContent;
import chatty.util.dnd.DockDropInfo;
import chatty.util.dnd.DockImportInfo;
import chatty.util.dnd.DockLayoutElement;
import chatty.util.dnd.DockLayoutSplit;
import chatty.util.dnd.DockPath;
import chatty.util.dnd.DockPathEntry;
import chatty.util.dnd.DockSetting;
import chatty.util.dnd.DockTabsContainer;
import chatty.util.dnd.DockTransferInfo;
import chatty.util.dnd.DockUtil;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;

public class DockSplit
extends JSplitPane
implements DockChild {
    private DockBase base;
    private DockChild parent;
    private DockChild left;
    private DockChild right;

    public DockSplit(int orientation, DockChild left, DockChild right) {
        super(orientation, left.getComponent(), right.getComponent());
        this.left = left;
        this.right = right;
    }

    public DockSplit(int orientation) {
        super(orientation);
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    public DockChild getLeftChild() {
        return this.left;
    }

    public DockChild getRightChild() {
        return this.right;
    }

    public void setChildren(DockChild left, DockChild right) {
        this.setLeftComponent(left.getComponent());
        this.setRightComponent(right.getComponent());
        this.left = left;
        this.right = right;
    }

    @Override
    public void split(DockDropInfo info, DockContent content) {
        DockChild presentComp = null;
        if (this.checkComponent(this.left, info)) {
            presentComp = this.left;
        } else if (this.checkComponent(this.right, info)) {
            presentComp = this.right;
        }
        if (presentComp == null) {
            return;
        }
        DockTabsContainer newCompTabs = new DockTabsContainer();
        DockSplit newChildSplit = DockUtil.createSplit(info, presentComp, newCompTabs);
        if (newChildSplit != null) {
            this.base.applySettings(newChildSplit);
            newChildSplit.setBase(this.base);
            newChildSplit.setDockParent(this);
            this.base.applySettings(newCompTabs);
            newCompTabs.setBase(this.base);
            newCompTabs.setDockParent(newChildSplit);
            newCompTabs.addContent(content);
            presentComp.setDockParent(newChildSplit);
            if (this.checkComponent(this.left, info)) {
                this.setLeftComponent(newChildSplit);
                this.left = newChildSplit;
            } else if (this.checkComponent(this.right, info)) {
                this.setRightComponent(newChildSplit);
                this.right = newChildSplit;
            }
            DockSplit split = newChildSplit;
            split.setDividerLocation(0.5);
            split.setResizeWeight(0.5);
            SwingUtilities.invokeLater(() -> {
                split.setDividerLocation(0.5);
                split.setResizeWeight(0.5);
            });
            DockUtil.preserveDividerLocation(this);
        }
    }

    private boolean checkComponent(DockChild parent, DockDropInfo info) {
        if (parent == info.dropComponent) {
            return true;
        }
        return parent == info.dropComponent.getComponent().getParent();
    }

    @Override
    public void addContent(DockContent content) {
        DockPathEntry next = DockUtil.getNext(content, this);
        if (next != null) {
            Debugging.println("dndp", "%s -> %s", this, next);
            if (next.type == DockPathEntry.Type.SPLIT && (next.location == DockDropInfo.DropType.RIGHT || next.location == DockDropInfo.DropType.BOTTOM)) {
                this.right.addContent(content);
            } else {
                this.left.addContent(content);
            }
        } else {
            this.left.addContent(content);
        }
    }

    @Override
    public void removeContent(DockContent content) {
        this.left.removeContent(content);
        this.right.removeContent(content);
    }

    @Override
    public void setBase(DockBase base) {
        this.base = base;
    }

    @Override
    public DockDropInfo findDrop(DockImportInfo info) {
        Point p;
        Rectangle leftBounds = this.getLeftComponent().getBounds();
        if (leftBounds.contains(p = info.getLocation(this))) {
            return this.left.findDrop(info);
        }
        if (this.getRightComponent().getBounds().contains(p)) {
            return this.right.findDrop(info);
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public void drop(DockTransferInfo info) {
    }

    @Override
    public void setDockParent(DockChild parent) {
        this.parent = parent;
    }

    @Override
    public DockChild getDockParent() {
        return this.parent;
    }

    @Override
    public String toString() {
        if (this.getOrientation() == 1) {
            return String.format("%s || %s", this.left, this.right);
        }
        return String.format("%s -- %s", this.left, this.right);
    }

    @Override
    public void replace(DockChild old, DockChild replacement) {
        if (old == this.left) {
            if (replacement == null) {
                this.parent.replace(this, this.right);
                DockUtil.activeTabAfterJoin(this.right, this.base);
            } else {
                this.setLeftComponent(replacement.getComponent());
                this.left = replacement;
                replacement.setDockParent(this);
                DockUtil.preserveDividerLocation(this);
            }
        } else if (old == this.right) {
            if (replacement == null) {
                this.parent.replace(this, this.left);
                DockUtil.activeTabAfterJoin(this.left, this.base);
            } else {
                this.setRightComponent(replacement.getComponent());
                this.right = replacement;
                replacement.setDockParent(this);
                DockUtil.preserveDividerLocation(this);
            }
        }
    }

    @Override
    public List<DockContent> getContents() {
        ArrayList<DockContent> result = new ArrayList<DockContent>();
        result.addAll(this.left.getContents());
        result.addAll(this.right.getContents());
        return result;
    }

    @Override
    public void setActiveContent(DockContent content) {
        this.left.setActiveContent(content);
        this.right.setActiveContent(content);
    }

    @Override
    public boolean isContentVisible(DockContent content) {
        return this.left.isContentVisible(content) || this.right.isContentVisible(content);
    }

    @Override
    public List<DockContent> getContentsRelativeTo(DockContent content, int direction) {
        if (this.left.getContents().contains(content)) {
            return this.left.getContentsRelativeTo(content, direction);
        }
        return this.right.getContentsRelativeTo(content, direction);
    }

    @Override
    public void setSetting(DockSetting.Type setting, Object value) {
        this.left.setSetting(setting, value);
        this.right.setSetting(setting, value);
        if (setting == DockSetting.Type.DEBUG) {
            this.setBorder(value == Boolean.TRUE ? BorderFactory.createLineBorder(Color.BLUE, 4) : null);
        }
        if (setting == DockSetting.Type.DIVIDER_SIZE) {
            this.setDividerSize(((Number)value).intValue());
        }
    }

    @Override
    public DockPath getPath() {
        return this.parent.buildPath(new DockPath(), this);
    }

    @Override
    public DockPath buildPath(DockPath path, DockChild child) {
        DockDropInfo.DropType type = null;
        if (child == this.left) {
            type = this.getOrientation() == 1 ? DockDropInfo.DropType.LEFT : DockDropInfo.DropType.TOP;
        } else if (child == this.right) {
            type = this.getOrientation() == 1 ? DockDropInfo.DropType.RIGHT : DockDropInfo.DropType.BOTTOM;
        }
        path.addParent(DockPathEntry.createSplit(type));
        return this.parent.buildPath(path, this);
    }

    @Override
    public DockLayoutElement getLayoutElement() {
        return new DockLayoutSplit(this.left.getLayoutElement(), this.right.getLayoutElement(), this.getDividerLocation(), this.getOrientation());
    }

    @Override
    public void cleanUp() {
        this.left.cleanUp();
        this.right.cleanUp();
    }

    @Override
    public void sortContent(DockContent content) {
        this.left.sortContent(content);
        this.right.sortContent(content);
    }
}

