/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.dnd;

import chatty.util.dnd.DockBase;
import chatty.util.dnd.DockChild;
import chatty.util.dnd.DockContent;
import chatty.util.dnd.DockDropInfo;
import chatty.util.dnd.DockExportHandler;
import chatty.util.dnd.DockImportInfo;
import chatty.util.dnd.DockLayoutElement;
import chatty.util.dnd.DockLayoutTabs;
import chatty.util.dnd.DockPath;
import chatty.util.dnd.DockSetting;
import chatty.util.dnd.DockTabComponent;
import chatty.util.dnd.DockTabsContainer;
import chatty.util.dnd.DockTransferInfo;
import chatty.util.dnd.DockTransferable;
import chatty.util.dnd.DockUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DockTabs
extends JTabbedPane
implements DockChild {
    private static final Logger LOGGER = Logger.getLogger(DockTabs.class.getName());
    private final DockExportHandler transferHandler;
    private final Map<JComponent, DockContent> assoc = new HashMap<JComponent, DockContent>();
    private final DockContent.DockContentPropertyListener dockContentListener;
    private DockChild parent;
    private DockBase base;
    private LinkedList<DockContent> prevActiveContent = new LinkedList();
    private boolean sorting;
    private boolean canStartDrag;
    private long dragStarted;
    private int dragIndex;
    private boolean mouseWheelScrolling = true;
    private boolean mouseWheelScrollingAnywhere = true;
    private boolean closeTabMMB = true;
    private boolean closeTabSwitchToPrev = false;
    private DockSetting.TabOrder order = DockSetting.TabOrder.INSERTION;
    private Comparator<DockContent> customComparator;
    private static final Comparator<DockContent> ALPHABETIC_COMPARATOR = new Comparator<DockContent>(){

        @Override
        public int compare(DockContent o1, DockContent o2) {
            return o1.getTitle().compareToIgnoreCase(o2.getTitle());
        }
    };

    public DockTabs() {
        this.transferHandler = new DockExportHandler(this);
        this.setTransferHandler(this.transferHandler);
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (!DockTabs.this.canStartDrag) {
                    return;
                }
                if (DockTabs.this.dragStarted == 0L) {
                    DockTabs.this.dragStarted = System.currentTimeMillis();
                    DockTabs.this.dragIndex = DockTabs.this.getIndexForPoint(e.getPoint());
                }
                if (DockTabs.this.dragIndex >= 0 && System.currentTimeMillis() - DockTabs.this.dragStarted > 120L) {
                    DockTabs.this.transferHandler.drag(DockTabs.this.dragIndex, e);
                    DockTabs.this.base.requestDrag(DockTabs.this.getContent(DockTabs.this.dragIndex).canPopout());
                    DockTabs.this.canStartDrag = false;
                }
                DockTabs.this.repaint();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                DockTabs.this.dragStarted = 0L;
                DockTabs.this.canStartDrag = SwingUtilities.isLeftMouseButton(e);
                DockTabs.this.openPopupMenu(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                DockTabs.this.dragStarted = 0L;
                DockTabs.this.repaint();
                DockTabs.this.base.requestStopDrag(null);
                DockTabs.this.openPopupMenu(e);
                DockTabs.this.closeTab(e);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                DockTabs.this.openPopupMenu(e);
            }
        });
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                if (DockTabs.this.mouseWheelScrolling) {
                    int index = DockTabs.this.indexAtLocation(e.getX(), e.getY());
                    if (DockTabs.this.mouseWheelScrollingAnywhere || index != -1 || DockTabs.this.isNearLastTab(e.getPoint())) {
                        if (e.getWheelRotation() < 0) {
                            DockTabs.this.setSelectedPrevious();
                        } else if (e.getWheelRotation() > 0) {
                            DockTabs.this.setSelectedNext();
                        }
                    }
                }
            }
        });
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!DockTabs.this.sorting) {
                    DockTabs.this.updatedState();
                }
            }
        });
        this.dockContentListener = new DockContent.DockContentPropertyListener(){

            @Override
            public void propertyChanged(DockContent.DockContentPropertyListener.Property property, DockContent content) {
                if (property == DockContent.DockContentPropertyListener.Property.TITLE) {
                    int index = DockTabs.this.getIndexByContent(content);
                    if (index != -1) {
                        DockTabs.this.setTitleAt(index, content.getTitle());
                    }
                } else if (property == DockContent.DockContentPropertyListener.Property.FOREGROUND) {
                    int index = DockTabs.this.getIndexByContent(content);
                    if (index != -1) {
                        DockTabs.this.setForegroundAt(index, content.getForegroundColor());
                    }
                } else if (property == DockContent.DockContentPropertyListener.Property.LONG_TITLE) {
                    DockTabs.this.updateTitledComponent(content);
                }
            }
        };
    }

    @Override
    public void setBase(DockBase base) {
        this.base = base;
    }

    public void requestStopDrag(DockTransferable t) {
        this.base.requestStopDrag(t);
    }

    @Override
    public void setDockParent(DockChild parent) {
        this.parent = parent;
    }

    @Override
    public DockChild getDockParent() {
        return this.parent;
    }

    @Override
    public void split(DockDropInfo info, DockContent content) {
        this.parent.split(info, content);
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    private void openPopupMenu(MouseEvent e) {
        JPopupMenu menu;
        if (!e.isPopupTrigger()) {
            return;
        }
        DockContent content = this.getContentForEvent(e);
        if (content != null && (menu = content.getContextMenu()) != null) {
            menu.show(this, e.getX(), e.getY());
        }
    }

    private void closeTab(MouseEvent e) {
        if (!SwingUtilities.isMiddleMouseButton(e) || e.isPopupTrigger()) {
            return;
        }
        if (!this.closeTabMMB) {
            return;
        }
        DockContent content = this.getContentForEvent(e);
        if (content != null) {
            content.remove();
        }
    }

    private void updatedState() {
        DockContent current;
        this.dragStarted = 0L;
        this.repaint();
        if (this.base != null) {
            this.base.tabChanged(this, this.getCurrentContent());
        }
        if ((current = this.getCurrentContent()) != null) {
            this.prevActiveContent.remove(current);
            this.prevActiveContent.add(current);
            if (this.prevActiveContent.size() > 100) {
                this.prevActiveContent.removeFirst();
            }
        }
        this.updateTabComponents();
    }

    private void updateTabComponent(DockContent content) {
        int index = this.getIndexByContent(content);
        if (index != -1) {
            JComponent comp;
            DockTabComponent tabComp = content.getTabComponent();
            JComponent jComponent = comp = tabComp != null ? tabComp.getComponent() : null;
            if (this.getTabComponentAt(index) != comp) {
                this.setTabComponentAt(index, comp);
            }
            if (tabComp != null) {
                tabComp.update(this, index);
            }
        }
    }

    private void updateTabComponents() {
        this.assoc.entrySet().forEach(e -> this.updateTabComponent((DockContent)e.getValue()));
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.assoc != null) {
            this.updateTabComponents();
        }
    }

    @Override
    public void addContent(DockContent content) {
        if (this.assoc.containsValue(content)) {
            return;
        }
        this.addContent(content, this.findInsertPosition(content));
    }

    private void addContent(DockContent content, int index) {
        JComponent comp = content.getComponent();
        if (content.getLongTitle() != null) {
            comp = new TitledContent(content);
        }
        this.assoc.put(comp, content);
        this.insertTab(content.getTitle(), null, comp, null, index);
        this.updateTabComponent(content);
        content.addListener(this.dockContentListener);
        this.updateTitledComponent(content);
    }

    @Override
    public void removeContent(DockContent content) {
        if (this.closeTabSwitchToPrev && content == this.getCurrentContent()) {
            Iterator<DockContent> it = this.prevActiveContent.descendingIterator();
            while (it.hasNext()) {
                DockContent c = it.next();
                it.remove();
                if (content == c || !this.containsContent(c)) continue;
                this.setActiveContent(c);
                break;
            }
        }
        this.prevActiveContent.remove(content);
        content.removeListener(this.dockContentListener);
        JComponent comp = this.getComponentByContent(content);
        this.assoc.remove(comp);
        this.remove(comp);
        if (this.getTabCount() == 0) {
            this.parent.replace(this, null);
        } else if (this.getTabCount() == 1) {
            ((DockTabsContainer)this.parent).updateSingleAllowed();
        }
    }

    public void updateSingleAllowed() {
        new ArrayList<DockContent>(this.assoc.values()).forEach(content -> this.updateTitledComponent((DockContent)content));
    }

    private void updateTitledComponent(DockContent content) {
        JComponent comp = this.getComponentByContent(content);
        if (content.getLongTitle() == null || !((DockTabsContainer)this.parent).isInSplit()) {
            if (comp instanceof TitledContent) {
                int index = this.getIndexByContent(content);
                this.setComponentAt(index, content.getComponent());
                this.assoc.remove(comp);
                this.assoc.put(content.getComponent(), content);
            }
        } else if (comp instanceof TitledContent) {
            ((TitledContent)comp).setTitle(content.getLongTitle());
        } else {
            int index = this.getIndexByContent(content);
            TitledContent titledContent = new TitledContent(null);
            this.setComponentAt(index, titledContent);
            titledContent.setComponent(content);
            titledContent.setTitle(content.getLongTitle());
            this.assoc.remove(comp);
            this.assoc.put(titledContent, content);
        }
    }

    public boolean containsContent(DockContent content) {
        return this.assoc.containsValue(content);
    }

    @Override
    public List<DockContent> getContents() {
        ArrayList<DockContent> result = new ArrayList<DockContent>();
        for (int i = 0; i < this.getTabCount(); ++i) {
            result.add(this.getContent(i));
        }
        return result;
    }

    @Override
    public boolean isEmpty() {
        return this.getTabCount() == 0;
    }

    @Override
    public void setActiveContent(DockContent content) {
        JComponent comp = this.getComponentByContent(content);
        if (comp != null && this.getSelectedComponent() != comp) {
            try {
                this.setSelectedComponent(comp);
            }
            catch (IllegalArgumentException ex) {
                LOGGER.warning("Error setting active content " + content.getId() + ": " + ex);
            }
        }
    }

    public void setSelectedNext() {
        int count;
        int index = this.getSelectedIndex();
        if (index + 1 < (count = this.getTabCount())) {
            this.setSelectedIndex(index + 1);
        } else if (count > 0) {
            this.setSelectedIndex(0);
        }
    }

    public void setSelectedPrevious() {
        int index = this.getSelectedIndex();
        int count = this.getTabCount();
        if (count > 0) {
            if (index - 1 >= 0) {
                this.setSelectedIndex(index - 1);
            } else {
                this.setSelectedIndex(count - 1);
            }
        }
    }

    @Override
    public boolean isContentVisible(DockContent content) {
        return this.getSelectedComponent() != null && this.getSelectedComponent() == this.getComponentByContent(content);
    }

    @Override
    public List<DockContent> getContentsRelativeTo(DockContent content, int direction) {
        ArrayList<DockContent> result = new ArrayList<DockContent>();
        int index = this.indexOfComponent(this.getComponentByContent(content));
        if (index != -1) {
            int i;
            if (direction == 1 || direction == 0) {
                for (i = index + 1; i < this.getTabCount(); ++i) {
                    result.add(this.getContent(i));
                }
            }
            if (direction == -1 || direction == 0) {
                for (i = index - 1; i >= 0; --i) {
                    result.add(this.getContent(i));
                }
            }
        }
        return result;
    }

    public DockContent getContent(int index) {
        return this.assoc.get(this.getComponentAt(index));
    }

    private JComponent getComponentByContent(DockContent content) {
        for (Map.Entry<JComponent, DockContent> entry : this.assoc.entrySet()) {
            if (entry.getValue() != content) continue;
            return entry.getKey();
        }
        return null;
    }

    public int getIndexByContent(DockContent content) {
        for (int i = 0; i < this.getTabCount(); ++i) {
            if (this.getContent(i) != content) continue;
            return i;
        }
        return -1;
    }

    public int getIndexByContentId(String id) {
        for (int i = 0; i < this.getTabCount(); ++i) {
            if (!this.getContent(i).getId().equals(id)) continue;
            return i;
        }
        return -1;
    }

    public DockContent getCurrentContent() {
        if (this.getSelectedIndex() == -1) {
            return null;
        }
        return this.getContent(this.getSelectedIndex());
    }

    @Override
    public DockDropInfo findDrop(DockImportInfo info) {
        int index = this.getDropIndexForPoint(info.getLocation(this));
        if (index >= 0) {
            if (!this.validDropIndex(info, index)) {
                return new DockDropInfo(this, DockDropInfo.DropType.INVALID, null, index);
            }
            return new DockDropInfo(this, DockDropInfo.DropType.TAB, this.getDropRectangle(index), index);
        }
        if (this.getTabCount() == 1 && info.tf.source == this) {
            return null;
        }
        if (DockDropInfo.determineLocation(this, info.getLocation(this), 30, 1400, 20) == DockDropInfo.DropType.CENTER && info.tf.source != this) {
            return new DockDropInfo(this, DockDropInfo.DropType.TAB, DockDropInfo.makeRect(this, DockDropInfo.DropType.CENTER, 40, 100000), -1);
        }
        DockDropInfo.DropType location = DockDropInfo.determineLocation(this, info.getLocation(this), 20, 80, 20);
        if (location != null && location != DockDropInfo.DropType.CENTER) {
            return new DockDropInfo(this, location, DockDropInfo.makeRect(this, location, 20, 20, 80), -1);
        }
        return null;
    }

    private boolean validDropIndex(DockImportInfo info, int index) {
        return info.tf.source != this || info.tf.sourceIndex != index && info.tf.sourceIndex + 1 != index;
    }

    private Rectangle getDropRectangle(int index) {
        boolean drawBeforeTab = true;
        if (index >= this.getTabCount()) {
            index = this.getTabCount() - 1;
            drawBeforeTab = false;
        }
        Rectangle bounds = this.getUI().getTabBounds(this, index);
        if (drawBeforeTab) {
            if (this.tabsAreHorizontal()) {
                return new Rectangle(bounds.x, bounds.y, 3, bounds.height);
            }
            return new Rectangle(bounds.x, bounds.y, bounds.width, 3);
        }
        if (this.tabsAreHorizontal()) {
            return new Rectangle(bounds.x + bounds.width - 3, bounds.y, 3, bounds.height);
        }
        return new Rectangle(bounds.x, bounds.y + bounds.height - 3, bounds.width, 3);
    }

    private int getDropIndexForPoint(Point p) {
        int index = this.getIndexForPoint(p);
        if (index >= 0) {
            boolean isCurrentTab;
            Rectangle bounds = this.getBoundsAt(index);
            if (this.tabsAreHorizontal()) {
                isCurrentTab = p.x < bounds.x + bounds.width / 2;
            } else {
                boolean bl = isCurrentTab = p.y < bounds.y + bounds.height / 2;
            }
            if (isCurrentTab) {
                return index;
            }
            return index + 1;
        }
        if (this.getTabCount() > 0) {
            Rectangle bounds = this.getBoundsAt(this.getTabCount() - 1);
            if (this.tabsAreHorizontal()) {
                bounds.width += 300;
            } else {
                bounds.height += 300;
            }
            if (bounds.contains(p)) {
                return this.getTabCount();
            }
        }
        return -1;
    }

    @Override
    public void drop(DockTransferInfo info) {
        info.importInfo.content.setTargetPath(null);
        if (info.dropInfo.location != DockDropInfo.DropType.TAB) {
            info.importInfo.source.removeContent(info.importInfo.content);
            this.split(info.dropInfo, info.importInfo.content);
            return;
        }
        int targetIndex = info.dropInfo.index;
        if (targetIndex == -1) {
            targetIndex = this.findInsertPosition(info.importInfo.content);
        }
        if (info.importInfo.source == this) {
            this.moveTab(info.importInfo.sourceIndex, targetIndex);
        } else {
            DockContent content = info.importInfo.content;
            DockTabsContainer container = (DockTabsContainer)this.parent;
            container.setSingleAllowedLocked();
            container.switchToTabs();
            info.importInfo.source.removeContent(content);
            this.addContent(content, targetIndex);
            content.setDockParent(this.parent);
            this.setSelectedIndex(targetIndex);
            container.resetSingleAllowed();
        }
    }

    private void moveTab(int from, int to) {
        if (from == to) {
            return;
        }
        Component comp = this.getComponentAt(from);
        String title = this.getTitleAt(from);
        String toolTip = this.getToolTipTextAt(from);
        Icon icon = this.getIconAt(from);
        Component tabComp = this.getTabComponentAt(from);
        DockContent content = this.getContent(from);
        this.removeTabAt(from);
        if (from < to) {
            --to;
        }
        if (to == -1) {
            to = this.findInsertPosition(content);
        }
        this.insertTab(title, icon, comp, toolTip, to);
        this.setTabComponentAt(to, tabComp);
        this.setSelectedComponent(comp);
    }

    @Override
    public String toString() {
        if (this.getTabCount() == 0) {
            return "EmptyTabs";
        }
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < this.getTabCount(); ++i) {
            b.append("[").append(this.getTitleAt(i)).append("]");
        }
        return b.toString();
    }

    @Override
    public void replace(DockChild old, DockChild replacement) {
    }

    @Override
    public void setSetting(DockSetting.Type setting, Object value) {
        switch (setting) {
            case TAB_SCROLL: {
                this.mouseWheelScrolling = DockSetting.getBoolean(value);
                break;
            }
            case TAB_SCROLL_ANYWHERE: {
                this.mouseWheelScrollingAnywhere = DockSetting.getBoolean(value);
                break;
            }
            case TAB_CLOSE_MMB: {
                this.closeTabMMB = DockSetting.getBoolean(value);
                break;
            }
            case TAB_CLOSE_SWITCH_TO_PREV: {
                this.closeTabSwitchToPrev = DockSetting.getBoolean(value);
                break;
            }
            case TAB_PLACEMENT: {
                this.setTabPlacement(DockSetting.getInteger(value));
                break;
            }
            case TAB_LAYOUT: {
                this.setTabLayoutPolicy(DockSetting.getInteger(value));
                break;
            }
            case TAB_ORDER: {
                this.order = (DockSetting.TabOrder)((Object)value);
                break;
            }
            case TAB_COMPARATOR: {
                this.customComparator = (Comparator)value;
            }
        }
    }

    private boolean tabsAreHorizontal() {
        return this.getTabPlacement() == 1 || this.getTabPlacement() == 3;
    }

    private int findInsertPosition(DockContent content) {
        Comparator<DockContent> comparator = this.customComparator;
        if (comparator == null && this.order == DockSetting.TabOrder.ALPHABETIC) {
            comparator = ALPHABETIC_COMPARATOR;
        }
        if (comparator != null) {
            for (int i = 0; i < this.getTabCount(); ++i) {
                DockContent tabContent = this.getContent(i);
                if (comparator.compare(content, tabContent) >= 0) continue;
                return i;
            }
        }
        return this.getTabCount();
    }

    @Override
    public void sortContent(DockContent content) {
        if (this.getTabCount() < 2) {
            return;
        }
        if (content == null) {
            this.sorting = true;
            Component selected = this.getSelectedComponent();
            List<DockContent> contents = this.getContents();
            contents.forEach(c -> this.moveTab(this.getIndexByContent((DockContent)c), -1));
            this.setSelectedComponent(selected);
            this.sorting = false;
            this.updatedState();
        } else if (this.containsContent(content)) {
            this.moveTab(this.getIndexByContent(content), -1);
        }
    }

    private int getIndexForPoint(Point p) {
        return this.indexAtLocation(p.x, p.y);
    }

    private DockContent getContentForEvent(MouseEvent e) {
        int index = this.indexAtLocation(e.getX(), e.getY());
        if (index != -1) {
            return this.getContent(index);
        }
        return null;
    }

    private boolean isNearLastTab(Point p) {
        Rectangle bounds = this.getBoundsAt(this.getTabCount() - 1);
        bounds.width += 99999;
        return bounds.contains(p);
    }

    protected Image createScreenshot(int index) {
        Rectangle bounds = this.getBoundsAt(index);
        BufferedImage totalImage = new BufferedImage(this.getWidth(), this.getHeight(), 2);
        Graphics totalGraphics = ((Image)totalImage).getGraphics();
        totalGraphics.setClip(bounds);
        this.paintAll(totalGraphics);
        BufferedImage result = new BufferedImage(bounds.width, bounds.height, 2);
        Graphics g = ((Image)result).getGraphics();
        g.drawImage(totalImage, 0, 0, bounds.width, bounds.height, bounds.x, bounds.y, bounds.x + bounds.width, bounds.y + bounds.height, this);
        return result;
    }

    @Override
    public DockPath getPath() {
        return this.parent.getPath();
    }

    @Override
    public DockPath buildPath(DockPath path, DockChild child) {
        return this.parent.buildPath(path, child);
    }

    @Override
    public DockLayoutElement getLayoutElement() {
        DockContent active = this.getCurrentContent();
        return new DockLayoutTabs(DockUtil.getContentIds(this.getContents()), active != null ? active.getId() : null);
    }

    @Override
    public void cleanUp() {
        for (DockContent c : this.getContents()) {
            c.removeListener(this.dockContentListener);
        }
    }

    private static class TitledContent
    extends JPanel {
        private final JLabel title = new JLabel(){

            @Override
            public Dimension getMinimumSize() {
                return new Dimension(0, 0);
            }
        };

        TitledContent(DockContent content) {
            this.title.setBorder(BorderFactory.createEmptyBorder(2, 4, 4, 5));
            this.title.setHorizontalAlignment(0);
            this.setLayout(new BorderLayout());
            if (content != null) {
                this.setComponent(content);
            }
        }

        public void setTitle(String newTitle) {
            this.title.setText(newTitle);
            this.title.setToolTipText(newTitle);
        }

        public final void setComponent(DockContent content) {
            content.getComponent().setVisible(true);
            this.add((Component)this.title, "North");
            this.add((Component)content.getComponent(), "Center");
        }
    }
}

