/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.dnd;

import chatty.util.dnd.DockBase;
import chatty.util.dnd.DockChild;
import chatty.util.dnd.DockContent;
import chatty.util.dnd.DockDropInfo;
import chatty.util.dnd.DockImportInfo;
import chatty.util.dnd.DockLayoutElement;
import chatty.util.dnd.DockLayoutTabs;
import chatty.util.dnd.DockPath;
import chatty.util.dnd.DockPathEntry;
import chatty.util.dnd.DockSetting;
import chatty.util.dnd.DockTabs;
import chatty.util.dnd.DockTransferInfo;
import chatty.util.dnd.DockUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.util.Arrays;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DockTabsContainer
extends JPanel
implements DockChild {
    private DockBase base;
    private DockContent singleContent;
    private DockChild parent;
    private final DockTabs tabs;
    private boolean singleAllowed;
    private boolean singeAllowedLocked;
    private boolean noSingle;
    private JPanel emptyLayout;
    private boolean keepEmpty = false;

    public DockTabsContainer() {
        this.setLayout(new BorderLayout());
        this.tabs = new DockTabs();
        this.tabs.setDockParent(this);
        this.addEmptyLayout();
    }

    private void addEmptyLayout() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        JLabel info = new JLabel("Nothing here at the moment.");
        info.setToolTipText("Drag&drop content here. In some cases content may also still be added automatically.");
        info.setAlignmentX(0.5f);
        JButton removeButton = new JButton("Remove");
        removeButton.setToolTipText("Remove this empty content area.");
        removeButton.setAlignmentX(0.5f);
        removeButton.addActionListener(e -> {
            if (this.isEmpty()) {
                this.cleanUp();
                this.parent.replace(this, null);
            }
        });
        panel.add(Box.createVerticalGlue());
        panel.add(info);
        panel.add(Box.createVerticalStrut(5));
        panel.add(removeButton);
        panel.add(Box.createVerticalGlue());
        this.add((Component)panel, "Center");
        this.emptyLayout = panel;
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(0, 0);
    }

    public void setSingleAllowed(boolean allowed) {
        if (allowed && this.tabs.getTabCount() == 1) {
            this.switchToSingle();
        } else if (this.singleContent != null) {
            this.switchToTabs();
        }
        this.singleAllowed = allowed;
    }

    public boolean isSingleAllowed() {
        return this.singleAllowed;
    }

    public boolean isInSplit() {
        return !(this.parent instanceof DockBase);
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public void split(DockDropInfo info, DockContent content) {
        this.parent.split(info, content);
    }

    @Override
    public void replace(DockChild old, DockChild replacement) {
        if (replacement == null && !this.isEmpty()) {
            return;
        }
        if (replacement == null && this.keepEmpty) {
            this.remove(this.tabs);
            this.addEmptyLayout();
            return;
        }
        if (old == this.tabs) {
            old = this;
        }
        this.parent.replace(old, replacement);
    }

    private void switchToSingle() {
        if (this.singleContent != null) {
            return;
        }
        this.singleContent = this.tabs.getCurrentContent();
        if (this.singleContent != null) {
            this.tabs.removeContent(this.singleContent);
            this.add((Component)this.singleContent.getComponent(), "Center");
            this.remove(this.tabs);
        }
    }

    public void switchToTabs() {
        if (this.getComponentCount() == 0) {
            this.add((Component)this.tabs, "Center");
            return;
        }
        if (this.singleContent == null) {
            return;
        }
        Component focusedComp = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        this.remove(this.singleContent.getComponent());
        this.add((Component)this.tabs, "Center");
        this.tabs.addContent(this.singleContent);
        if (focusedComp != null) {
            focusedComp.requestFocusInWindow();
        }
        this.singleContent = null;
    }

    @Override
    public void addContent(DockContent content) {
        if (this.emptyLayout != null) {
            this.remove(this.emptyLayout);
        }
        if (this.tabs.getTabCount() == 0) {
            if (this.singleContent == null && this.singleAllowed) {
                this.add((Component)content.getComponent(), "Center");
                this.singleContent = content;
                this.validate();
                this.repaint();
            } else {
                this.switchToTabs();
                this.tabs.addContent(content);
            }
        } else {
            this.tabs.addContent(content);
        }
        content.setDockParent(this);
        content.setTargetPath(null);
    }

    @Override
    public void removeContent(DockContent content) {
        if (this.singleContent != null && this.singleContent == content) {
            this.remove(this.singleContent.getComponent());
            this.singleContent = null;
            this.validate();
            this.repaint();
            if (!this.keepEmpty) {
                this.parent.replace(this, null);
            } else {
                this.addEmptyLayout();
            }
        } else if (this.tabs.containsContent(content)) {
            this.tabs.removeContent(content);
            if (this.tabs.getTabCount() == 1 && this.singleAllowed) {
                this.switchToSingle();
            }
        }
        content.setDockParent(null);
    }

    @Override
    public void setBase(DockBase base) {
        this.base = base;
        this.tabs.setBase(base);
    }

    @Override
    public DockDropInfo findDrop(DockImportInfo info) {
        if (this.singleContent != null || this.isEmpty()) {
            DockDropInfo.DropType location = DockDropInfo.determineLocation(this, info.getLocation(this), 30, 1200, 20);
            if (location == DockDropInfo.DropType.CENTER) {
                return new DockDropInfo(this, DockDropInfo.DropType.TAB, DockDropInfo.makeRect(this, location, 40, 1200), this.isEmpty() ? 0 : 1);
            }
            return null;
        }
        return this.tabs.findDrop(info);
    }

    @Override
    public void drop(DockTransferInfo info) {
        if (this.isEmpty()) {
            info.importInfo.content.setTargetPath(null);
            DockContent content = info.importInfo.content;
            info.importInfo.source.removeContent(content);
            this.addContent(content);
        } else {
            this.tabs.drop(info);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.tabs.isEmpty() && this.singleContent == null;
    }

    @Override
    public void setDockParent(DockChild parent) {
        this.parent = parent;
        this.updateSingleAllowed();
    }

    @Override
    public DockChild getDockParent() {
        return this.parent;
    }

    public DockContent getCurrentContent() {
        if (this.singleContent != null) {
            return this.singleContent;
        }
        return this.tabs.getCurrentContent();
    }

    public void updateSingleAllowed() {
        if (!this.singeAllowedLocked) {
            this.setSingleAllowed(this.parent instanceof DockBase && !this.noSingle);
            this.tabs.updateSingleAllowed();
        }
    }

    public void setSingleAllowedLocked() {
        this.singeAllowedLocked = true;
    }

    public void resetSingleAllowed() {
        this.singeAllowedLocked = false;
        this.updateSingleAllowed();
    }

    @Override
    public List<DockContent> getContents() {
        if (this.singleContent != null) {
            return Arrays.asList(this.singleContent);
        }
        return this.tabs.getContents();
    }

    @Override
    public void setActiveContent(DockContent content) {
        this.tabs.setActiveContent(content);
    }

    @Override
    public boolean isContentVisible(DockContent content) {
        return this.singleContent == content || this.tabs.isContentVisible(content);
    }

    @Override
    public List<DockContent> getContentsRelativeTo(DockContent content, int direction) {
        return this.tabs.getContentsRelativeTo(content, direction);
    }

    @Override
    public void setSetting(DockSetting.Type setting, Object value) {
        this.tabs.setSetting(setting, value);
        if (setting == DockSetting.Type.DEBUG) {
            this.setBorder(value == Boolean.TRUE ? BorderFactory.createLineBorder(Color.RED, 4) : null);
        }
        if (setting == DockSetting.Type.KEEP_EMPTY) {
            this.keepEmpty = DockSetting.getBoolean(value);
        }
        if (setting == DockSetting.Type.NO_SINGLE) {
            this.noSingle = DockSetting.getBoolean(value);
            this.updateSingleAllowed();
        }
    }

    @Override
    public String toString() {
        if (this.singleContent != null) {
            return "-[" + this.singleContent.getTitle() + "]-";
        }
        return "-[" + this.tabs.toString() + "]-";
    }

    @Override
    public DockPath getPath() {
        return this.parent.buildPath(new DockPath(), this);
    }

    @Override
    public DockPath buildPath(DockPath path, DockChild child) {
        String contentId = path.getContentId();
        if (contentId != null) {
            if (this.singleContent != null && this.singleContent.getId().equals(contentId)) {
                path.addParent(DockPathEntry.createTab(0));
            } else {
                path.addParent(DockPathEntry.createTab(this.tabs.getIndexByContentId(contentId)));
            }
        }
        return this.parent.buildPath(path, this);
    }

    @Override
    public DockLayoutElement getLayoutElement() {
        DockContent active = this.getCurrentContent();
        return new DockLayoutTabs(DockUtil.getContentIds(this.getContents()), active != null ? active.getId() : null);
    }

    @Override
    public void cleanUp() {
        this.tabs.cleanUp();
    }

    @Override
    public void sortContent(DockContent content) {
        if (!this.tabs.isEmpty()) {
            this.tabs.sortContent(content);
        }
    }
}

