/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.dnd;

import chatty.util.dnd.DockBase;
import chatty.util.dnd.DockChild;
import chatty.util.dnd.DockContent;
import chatty.util.dnd.DockDropInfo;
import chatty.util.dnd.DockPath;
import chatty.util.dnd.DockPathEntry;
import chatty.util.dnd.DockSplit;
import chatty.util.dnd.DockTabsContainer;
import chatty.util.dnd.DockTransferable;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Window;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;

public class DockUtil {
    public static DockSplit createSplit(DockDropInfo info, DockChild prev, DockChild added) {
        DockSplit result = null;
        switch (info.location) {
            case LEFT: {
                result = new DockSplit(1, added, prev);
                break;
            }
            case RIGHT: {
                result = new DockSplit(1, prev, added);
                break;
            }
            case BOTTOM: {
                result = new DockSplit(0, prev, added);
                break;
            }
            case TOP: {
                result = new DockSplit(0, added, prev);
            }
        }
        return result;
    }

    public static boolean isMouseOverWindow() {
        Point p = MouseInfo.getPointerInfo().getLocation();
        for (Window w : Window.getWindows()) {
            if (!w.isVisible() || !w.getBounds().contains(p)) continue;
            return true;
        }
        return false;
    }

    public static DockTransferable getTransferable(TransferHandler.TransferSupport info) {
        try {
            return (DockTransferable)info.getTransferable().getTransferData(DockTransferable.FLAVOR);
        }
        catch (UnsupportedFlavorException | IOException ex) {
            System.out.println(ex);
            return null;
        }
    }

    public static DockTransferable getTransferable(Transferable t) {
        try {
            return (DockTransferable)t.getTransferData(DockTransferable.FLAVOR);
        }
        catch (UnsupportedFlavorException | IOException ex) {
            System.out.println(ex);
            return null;
        }
    }

    public static void activeTabAfterJoin(DockChild child, DockBase base) {
        if (base == null) {
            return;
        }
        if (child instanceof DockTabsContainer) {
            DockTabsContainer tabs = (DockTabsContainer)child;
            base.tabChanged(null, tabs.getCurrentContent());
        } else if (child instanceof DockSplit) {
            DockUtil.activeTabAfterJoin(((DockSplit)child).getLeftChild(), base);
        }
    }

    public static DockPathEntry getNext(DockContent content, DockChild current) {
        DockPath target = content.getTargetPath();
        if (target != null) {
            return target.getNext(current.getPath());
        }
        return null;
    }

    public static void preserveDividerLocation(JSplitPane split) {
        int location = split.getDividerLocation();
        SwingUtilities.invokeLater(() -> split.setDividerLocation(location));
    }

    public static List<String> getContentIds(List<DockContent> contents) {
        ArrayList<String> ids = new ArrayList<String>();
        for (DockContent c : contents) {
            if (c.getId() == null) continue;
            ids.add(c.getId());
        }
        return ids;
    }

    public static DockContent getContentById(Collection<DockContent> contents, String id) {
        for (DockContent content : contents) {
            if (!content.getId().equals(id)) continue;
            return content;
        }
        return null;
    }

    public static List<DockContent> getContentsByPrefix(List<DockContent> input, String prefix) {
        ArrayList<DockContent> result = new ArrayList<DockContent>();
        for (DockContent content : input) {
            if (!content.getId().startsWith(prefix)) continue;
            result.add(content);
        }
        return result;
    }
}

