/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.ffz;

import chatty.util.jws.JWSClient;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class FFZWS
extends JWSClient {
    private static final Logger LOGGER = Logger.getLogger(FFZWS.class.getName());
    private final Object LOCK = new Object();
    private int sentCount;
    private final MessageHandler handler;
    private final Map<Integer, String> commandId = new HashMap<Integer, String>();

    public FFZWS(URI server, MessageHandler handler) {
        super(server);
        this.handler = handler;
        this.setDebugPrefix("[FFZ-WS] ");
    }

    @Override
    public void handleReceived(String text) {
        this.handler.handleReceived(text);
        try {
            String[] split = text.split(" ", 3);
            int id = Integer.parseInt(split[0]);
            String command = split[1];
            String params = "";
            if (split.length == 3) {
                params = split[2];
            }
            this.handleCommand(id, command, params);
        }
        catch (ArrayIndexOutOfBoundsException | NumberFormatException ex) {
            LOGGER.warning("[FFZ-WS] Invalid message: " + text);
        }
    }

    @Override
    public void handleSent(String text) {
        this.handler.handleSent(text);
    }

    @Override
    public void handleConnect(JWSClient c) {
        this.reset();
        this.handler.handleConnect();
    }

    @Override
    public void handleDisconnect(int code) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reset() {
        Object object = this.LOCK;
        synchronized (object) {
            this.sentCount = 0;
            this.commandId.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleCommand(int id, String command, String params) {
        String originCommand = "";
        Object object = this.LOCK;
        synchronized (object) {
            String c = this.commandId.get(id);
            if (c != null) {
                originCommand = c;
            }
        }
        this.handler.handleCommand(id, command, params, originCommand);
        if (command.equals("error")) {
            LOGGER.warning("[FFZ-WS] Error: " + params);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendCommand(String command, String data) {
        String toSend = null;
        Object object = this.LOCK;
        synchronized (object) {
            if (this.isOpen()) {
                ++this.sentCount;
                toSend = data == null ? String.format("%d %s", this.sentCount, command) : String.format("%d %s %s", this.sentCount, command, data);
                this.commandId.put(this.sentCount, command);
            }
        }
        if (toSend != null) {
            this.sendMessage(toSend);
        }
    }

    public static interface MessageHandler {
        public void handleReceived(String var1);

        public void handleSent(String var1);

        public void handleCommand(int var1, String var2, String var3, String var4);

        public void handleConnect();
    }
}

