/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.ffz;

import chatty.Helper;
import chatty.util.RetryManager;
import chatty.util.StringUtil;
import chatty.util.UrlRequest;
import chatty.util.api.Emoticon;
import chatty.util.api.EmoticonUpdate;
import chatty.util.api.TwitchApi;
import chatty.util.api.usericons.Usericon;
import chatty.util.api.usericons.UsericonFactory;
import chatty.util.ffz.FrankerFaceZListener;
import chatty.util.ffz.FrankerFaceZParsing;
import chatty.util.ffz.WebsocketManager;
import chatty.util.settings.Settings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class FrankerFaceZ {
    private static final Logger LOGGER = Logger.getLogger(FrankerFaceZ.class.getName());
    private final FrankerFaceZListener listener;
    private boolean botNamesRequested;
    private String botBadgeId = null;
    private final Map<String, Map<String, Set<String>>> roomBadgeUsernames = new HashMap<String, Map<String, Set<String>>>();
    private static final long FEATURE_FRIDAY_UPDATE_DELAY = 21600000L;
    private boolean featureFridayTimerStarted;
    private String featureFridayChannel;
    private int featureFridaySet = -1;
    private final WebsocketManager ws;
    private final TwitchApi api;

    public FrankerFaceZ(FrankerFaceZListener listener, Settings settings, TwitchApi api) {
        this.listener = listener;
        this.ws = new WebsocketManager(listener, settings);
        this.api = api;
    }

    public void connectWs() {
        this.ws.connect();
    }

    public void disconnectWs() {
        this.ws.disconnect();
    }

    public String getWsStatus() {
        return this.ws.getStatus();
    }

    public boolean isWsConnected() {
        return this.ws.isConnected();
    }

    public void joined(String room) {
        room = Helper.toStream(room);
        this.ws.addRoom(room);
    }

    public void left(String room) {
        room = Helper.toStream(room);
        this.ws.removeRoom(room);
    }

    public void setFollowing(String user, String room, String following) {
        this.ws.setFollowing(user, room, following);
    }

    public synchronized void requestEmotes(String stream, boolean forcedUpdate) {
        if ((stream = Helper.toStream(stream)) == null || stream.isEmpty()) {
            return;
        }
        String username = stream;
        this.api.getUserId(r -> {
            if (!r.hasError()) {
                this.request(Type.ROOM, username, r.getId(username), forcedUpdate);
            }
        }, username);
        this.requestGlobalEmotes(false);
        if (!this.botNamesRequested) {
            this.requestBotNames();
            this.botNamesRequested = true;
        }
    }

    public synchronized void requestGlobalEmotes(boolean forcedUpdate) {
        this.request(Type.GLOBAL, null, null, forcedUpdate);
        this.requestFeatureFridayEmotes(forcedUpdate);
    }

    public synchronized void autoUpdateFeatureFridayEmotes() {
        if (this.featureFridayTimerStarted) {
            return;
        }
        this.featureFridayTimerStarted = true;
        Timer timer = new Timer("FFZ Feature Friday", true);
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                FrankerFaceZ.this.requestFeatureFridayEmotes(true);
            }
        }, 21600000L, 21600000L);
    }

    public synchronized void requestFeatureFridayEmotes(boolean forcedUpdate) {
        this.request(Type.FEATURE_FRIDAY, null, null, forcedUpdate);
    }

    private synchronized void request(Type type, String stream, String id, boolean forcedUpdate) {
        String url = this.getUrl(type, id);
        if (forcedUpdate) {
            this.requestNow(type, stream, id, url);
        } else {
            RetryManager.getInstance().retry(url, k -> this.requestNow(type, stream, id, url));
        }
    }

    private void requestNow(Type type, String stream, String id, String url) {
        UrlRequest request = new UrlRequest();
        request.setLabel("FFZ/" + stream);
        request.setUrl(url);
        request.async((result, responseCode) -> {
            if (Integer.toString(responseCode).startsWith("4")) {
                RetryManager.getInstance().setNotFound(url);
            } else if (responseCode != 200 && result == null) {
                RetryManager.getInstance().setError(url);
            } else {
                RetryManager.getInstance().setSuccess(url);
            }
            this.parseResult(type, stream, id, result);
        });
    }

    private String getUrl(Type type, String id) {
        if (type == Type.GLOBAL) {
            return "https://api.frankerfacez.com/v1/set/global";
        }
        if (type == Type.FEATURE_FRIDAY) {
            if (id == null) {
                return "https://cdn.frankerfacez.com/script/event.json";
            }
            return "https://api.frankerfacez.com/v1/set/" + id;
        }
        return "https://api.frankerfacez.com/v1/room/id/" + id;
    }

    private void parseResult(Type type, String stream, String id, String result) {
        if (result == null) {
            return;
        }
        if (type == Type.FEATURE_FRIDAY && id == null) {
            this.handleFeatureFriday(result);
            return;
        }
        boolean global = type == Type.GLOBAL || type == Type.FEATURE_FRIDAY;
        String globalText = global ? "global" : "local";
        Set<Object> emotes = new HashSet();
        ArrayList<Usericon> usericons = new ArrayList<Usericon>();
        if (type == Type.GLOBAL) {
            emotes = FrankerFaceZParsing.parseGlobalEmotes(result);
        } else if (type == Type.ROOM) {
            emotes = FrankerFaceZParsing.parseRoomEmotes(result, stream);
            this.addRoomBadgeUsernames(stream, FrankerFaceZParsing.parseRoomBadges(result));
            String modIconUrl = FrankerFaceZParsing.parseCustomBadge(result, stream, "mod_urls", "1");
            String string = FrankerFaceZParsing.parseCustomBadge(result, stream, "mod_urls", "2");
            if (modIconUrl != null) {
                usericons.add(UsericonFactory.createTwitchLikeIcon(Usericon.Type.MOD, stream, modIconUrl, string, 10, "Moderator (FFZ)"));
            }
            String vipIconUrl = FrankerFaceZParsing.parseCustomBadge(result, stream, "vip_badge", "1");
            String vipIconUrl2 = FrankerFaceZParsing.parseCustomBadge(result, stream, "vip_badge", "2");
            if (vipIconUrl != null) {
                usericons.add(UsericonFactory.createIconFromUrl(Usericon.Type.VIP, stream, vipIconUrl, vipIconUrl2, 10, null, "VIP (FFZ)"));
            }
        } else if (type == Type.FEATURE_FRIDAY) {
            emotes = FrankerFaceZParsing.parseSetEmotes(result, Emoticon.SubType.FEATURE_FRIDAY, null);
            for (Emoticon emoticon : emotes) {
                if (this.featureFridayChannel == null) continue;
                emoticon.setStream(this.featureFridayChannel);
            }
        }
        LOGGER.info("|[FFZ] (" + stream + ", " + globalText + "): " + emotes.size() + " emotes received.");
        if (!usericons.isEmpty()) {
            LOGGER.info("|[FFZ] (" + stream + "): " + usericons.size() + " usericons received.");
        }
        EmoticonUpdate.Builder updateBuilder = new EmoticonUpdate.Builder(emotes);
        updateBuilder.setTypeToRemove(Emoticon.Type.FFZ);
        if (type == Type.FEATURE_FRIDAY) {
            updateBuilder.setSubTypeToRemove(Emoticon.SubType.FEATURE_FRIDAY);
        } else if (type == Type.ROOM) {
            updateBuilder.setSubTypeToRemove(Emoticon.SubType.REGULAR);
            updateBuilder.setRoomToRemove(stream);
        } else if (type == Type.GLOBAL) {
            updateBuilder.setSubTypeToRemove(Emoticon.SubType.REGULAR);
        }
        this.listener.channelEmoticonsReceived(updateBuilder.build());
        this.listener.usericonsReceived(usericons);
    }

    private void handleFeatureFriday(String json) {
        int set = this.parseFeatureFriday(json);
        if (set == -1) {
            this.featureFridaySet = -1;
            this.clearFeatureFridayEmotes();
            LOGGER.info(String.format("|[FFZ] No Feature Friday found: %s", StringUtil.trim(StringUtil.removeLinebreakCharacters(StringUtil.shortenTo(json, 100)))));
        } else {
            if (this.featureFridaySet != set) {
                this.clearFeatureFridayEmotes();
            }
            this.featureFridaySet = set;
            this.request(Type.FEATURE_FRIDAY, null, String.valueOf(set), true);
        }
    }

    private int parseFeatureFriday(String json) {
        try {
            JSONParser parser = new JSONParser();
            JSONObject root = (JSONObject)parser.parse(json);
            int set = ((Number)root.get("set")).intValue();
            this.featureFridayChannel = (String)root.get("channel");
            return set;
        }
        catch (ClassCastException | NullPointerException | ParseException exception) {
            this.featureFridayChannel = null;
            return -1;
        }
    }

    private void clearFeatureFridayEmotes() {
        EmoticonUpdate.Builder updateBuilder = new EmoticonUpdate.Builder(null);
        updateBuilder.setTypeToRemove(Emoticon.Type.FFZ);
        updateBuilder.setSubTypeToRemove(Emoticon.SubType.FEATURE_FRIDAY);
        this.listener.channelEmoticonsReceived(updateBuilder.build());
    }

    public void requestBotNames() {
        UrlRequest request = new UrlRequest("https://api.frankerfacez.com/v1/badge/bot");
        request.setLabel("FFZ Bots");
        request.async((result, responseCode) -> {
            if (result != null && responseCode == 200) {
                Set<String> botNames = FrankerFaceZParsing.getBotNames(result);
                LOGGER.info("|[FFZ Bots] Found " + botNames.size() + " names");
                this.listener.botNamesReceived(null, botNames);
                Map<String, Map<String, Set<String>>> map = this.roomBadgeUsernames;
                synchronized (map) {
                    this.botBadgeId = FrankerFaceZParsing.getBotBadgeId(result);
                }
                this.updateRoomBotNames();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRoomBadgeUsernames(String stream, Map<String, Set<String>> names) {
        if (stream == null || names == null || names.isEmpty()) {
            return;
        }
        Map<String, Map<String, Set<String>>> map = this.roomBadgeUsernames;
        synchronized (map) {
            this.roomBadgeUsernames.put(stream, names);
        }
        this.updateRoomBotNames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRoomBotNames() {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        Map<String, Map<String, Set<String>>> map = this.roomBadgeUsernames;
        synchronized (map) {
            if (this.botBadgeId != null) {
                for (Map.Entry<String, Map<String, Set<String>>> room : this.roomBadgeUsernames.entrySet()) {
                    String stream = room.getKey();
                    Set<String> names = room.getValue().get(this.botBadgeId);
                    if (names == null) continue;
                    result.put(stream, names);
                }
                this.roomBadgeUsernames.clear();
            }
        }
        for (Map.Entry entry : result.entrySet()) {
            LOGGER.info("|[FFZ Bots] (" + (String)entry.getKey() + "): Found " + ((Set)entry.getValue()).size() + " names");
            this.listener.botNamesReceived((String)entry.getKey(), (Set)entry.getValue());
        }
    }

    private static enum Type {
        GLOBAL,
        ROOM,
        FEATURE_FRIDAY;

    }
}

