/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.ffz;

import chatty.util.JSONUtil;
import chatty.util.api.Emoticon;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class FrankerFaceZParsing {
    private static final Logger LOGGER = Logger.getLogger(FrankerFaceZParsing.class.getName());

    public static String parseCustomBadge(String json, String stream, String type, String factor) {
        try {
            JSONParser parser = new JSONParser();
            JSONObject o = (JSONObject)parser.parse(json);
            JSONObject room = (JSONObject)o.get("room");
            Object badgeUrls = room.get(type);
            if (badgeUrls instanceof JSONObject) {
                return JSONUtil.getString((JSONObject)badgeUrls, factor);
            }
        }
        catch (ClassCastException | NullPointerException | ParseException exception) {
            // empty catch block
        }
        return null;
    }

    public static Set<Emoticon> parseGlobalEmotes(String json) {
        try {
            JSONParser parser = new JSONParser();
            JSONObject o = (JSONObject)parser.parse(json);
            JSONArray defaultSets = (JSONArray)o.get("default_sets");
            JSONObject sets = (JSONObject)o.get("sets");
            Iterator iterator = defaultSets.iterator();
            if (iterator.hasNext()) {
                Object setObject = iterator.next();
                int set = ((Number)setObject).intValue();
                JSONObject setData = (JSONObject)sets.get(String.valueOf(set));
                return FrankerFaceZParsing.parseEmoteSet(setData, null, Emoticon.SubType.REGULAR);
            }
        }
        catch (ClassCastException | NullPointerException | ParseException ex) {
            LOGGER.warning("Error parsing global FFZ emotes: " + ex);
        }
        return new HashSet<Emoticon>();
    }

    public static Set<Emoticon> parseRoomEmotes(String json, String stream) {
        try {
            JSONParser parser = new JSONParser();
            JSONObject o = (JSONObject)parser.parse(json);
            JSONObject room = (JSONObject)o.get("room");
            String roomId = (String)room.get("id");
            int set = ((Number)room.get("set")).intValue();
            JSONObject sets = (JSONObject)o.get("sets");
            JSONObject setData = (JSONObject)sets.get(String.valueOf(set));
            return FrankerFaceZParsing.parseEmoteSet(setData, stream, Emoticon.SubType.REGULAR);
        }
        catch (ClassCastException | NullPointerException | ParseException ex) {
            LOGGER.warning("Error parsing FFZ emotes: " + ex);
            return new HashSet<Emoticon>();
        }
    }

    public static Set<Emoticon> parseSetEmotes(String json, Emoticon.SubType subType, String room) {
        try {
            JSONParser parser = new JSONParser();
            JSONObject root = (JSONObject)parser.parse(json);
            JSONObject setData = (JSONObject)root.get("set");
            return FrankerFaceZParsing.parseEmoteSet(setData, room, subType);
        }
        catch (ClassCastException | NullPointerException | ParseException ex) {
            LOGGER.warning("Error parsing FFZ emotes: " + ex);
            return new HashSet<Emoticon>();
        }
    }

    public static Set<Emoticon> parseEmoteSet(JSONObject setData, String streamRestriction, Emoticon.SubType subType) {
        try {
            JSONArray emoticons = (JSONArray)setData.get("emoticons");
            String title = JSONUtil.getString(setData, "title");
            return FrankerFaceZParsing.parseEmoticons(emoticons, streamRestriction, title, subType);
        }
        catch (ClassCastException | NullPointerException ex) {
            LOGGER.warning("Error parsing FFZ emote set: " + ex);
            return new HashSet<Emoticon>();
        }
    }

    public static Set<Emoticon> parseEmoticons(JSONArray emotes, String streamRestriction, String info, Emoticon.SubType subType) {
        HashSet<Emoticon> result = new HashSet<Emoticon>();
        if (emotes != null) {
            for (Object emote : emotes) {
                Emoticon createdEmote;
                if (emote == null || !(emote instanceof JSONObject) || (createdEmote = FrankerFaceZParsing.parseEmote((JSONObject)emote, streamRestriction, info, subType)) == null) continue;
                result.add(createdEmote);
            }
        }
        return result;
    }

    public static Emoticon parseEmote(JSONObject emote, String streamRestriction, String info, Emoticon.SubType subType) {
        try {
            int width = JSONUtil.getInteger(emote, "width", -1);
            int height = JSONUtil.getInteger(emote, "height", -1);
            String code = (String)emote.get("name");
            JSONObject urls = (JSONObject)emote.get("urls");
            boolean isAnimated = false;
            if (emote.containsKey("animated")) {
                urls = (JSONObject)emote.get("animated");
                isAnimated = true;
            }
            int id = ((Number)emote.get("id")).intValue();
            Object owner = emote.get("owner");
            String creator = null;
            if (owner != null && owner instanceof JSONObject) {
                creator = (String)((JSONObject)owner).get("display_name");
            }
            if (code == null || code.isEmpty()) {
                return null;
            }
            Emoticon.Builder b = new Emoticon.Builder(Emoticon.Type.FFZ, code);
            for (Object key : urls.keySet()) {
                int scale = Integer.parseInt((String)key);
                String url = (String)urls.get(key);
                b.addUrl(scale, url);
            }
            b.setSize(width, height);
            b.setCreator(creator);
            b.setStringId(String.valueOf(id));
            b.addStreamRestriction(streamRestriction);
            b.setAnimated(isAnimated);
            b.addInfo(info);
            b.setSubType(subType);
            return b.build();
        }
        catch (ClassCastException | NullPointerException ex) {
            LOGGER.warning("Error parsing FFZ emote: " + ex);
            return null;
        }
    }

    public static Set<String> getBotNames(String json) {
        HashSet<String> result = new HashSet<String>();
        try {
            JSONParser parser = new JSONParser();
            JSONObject root = (JSONObject)parser.parse(json);
            JSONObject badge = (JSONObject)root.get("badge");
            if (badge.get("name").equals("bot")) {
                int badgeId = ((Number)badge.get("id")).intValue();
                JSONObject users = (JSONObject)root.get("users");
                JSONArray names = (JSONArray)users.get(String.valueOf(badgeId));
                for (Object item : names) {
                    if (item == null || !(item instanceof String)) continue;
                    result.add((String)item);
                }
            }
        }
        catch (Exception ex) {
            LOGGER.warning("Error parsing bot names: " + ex);
        }
        return result;
    }

    public static String getBotBadgeId(String json) {
        try {
            JSONParser parser = new JSONParser();
            JSONObject root = (JSONObject)parser.parse(json);
            JSONObject badge = (JSONObject)root.get("badge");
            Number id = (Number)badge.get("id");
            if (id == null) {
                return null;
            }
            return String.valueOf(id);
        }
        catch (Exception ex) {
            LOGGER.warning("Error parsing bot badge id: " + ex);
            return null;
        }
    }

    public static Map<String, Set<String>> parseRoomBadges(String json) {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        try {
            JSONParser parser = new JSONParser();
            JSONObject o = (JSONObject)parser.parse(json);
            JSONObject room = (JSONObject)o.get("room");
            JSONObject badges = (JSONObject)room.get("user_badges");
            for (Object key : badges.keySet()) {
                Object value = badges.get(key);
                if (!(key instanceof String) || !(value instanceof JSONArray)) continue;
                String badgeId = (String)key;
                JSONArray names = (JSONArray)value;
                HashSet<String> namesResult = new HashSet<String>();
                for (Object item : names) {
                    if (!(item instanceof String)) continue;
                    namesResult.add((String)item);
                }
                result.put(badgeId, namesResult);
            }
        }
        catch (Exception ex) {
            LOGGER.warning("Error parsing room badges: " + ex);
        }
        return result;
    }
}

