/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.ffz;

import chatty.Helper;
import chatty.util.JSONUtil;
import chatty.util.StringUtil;
import chatty.util.UrlRequest;
import chatty.util.api.Emoticon;
import chatty.util.api.EmoticonUpdate;
import chatty.util.ffz.FFZWS;
import chatty.util.ffz.FrankerFaceZListener;
import chatty.util.ffz.FrankerFaceZParsing;
import chatty.util.settings.Settings;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class WebsocketManager {
    private static final Logger LOGGER = Logger.getLogger(WebsocketManager.class.getName());
    private static final String VERSION = "chatty_0.28";
    private final Set<String> rooms = Collections.synchronizedSet(new HashSet());
    private final Map<String, Set<Integer>> prevEmotesets = new HashMap<String, Set<Integer>>();
    private volatile FFZWS c;
    private final JSONParser parser = new JSONParser();
    private final FrankerFaceZListener listener;
    private long serverTimeOffset;
    private final Settings settings;
    private String setUser;

    public WebsocketManager(FrankerFaceZListener listener, Settings settings) {
        this.listener = listener;
        this.settings = settings;
    }

    private static String[] getServers() {
        String main = "socket.frankerfacez.com";
        return new String[]{main};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getRooms() {
        Set<String> set = this.rooms;
        synchronized (set) {
            return new HashSet<String>(this.rooms);
        }
    }

    public String getStatus() {
        if (this.c != null) {
            return this.c.getStatus();
        }
        return "Not connected";
    }

    public boolean isConnected() {
        return this.c != null && this.c.isOpen();
    }

    public void connect() {
        if (!this.settings.getBoolean("ffz") || !this.settings.getBoolean("ffzEvent") || this.c != null) {
            return;
        }
        try {
            this.c = new FFZWS(new URI("wss://socket.frankerfacez.com"), new FFZWS.MessageHandler(){

                @Override
                public void handleReceived(String text) {
                    WebsocketManager.this.listener.wsInfo("--> " + text);
                }

                @Override
                public void handleSent(String sent) {
                    WebsocketManager.this.listener.wsInfo("<-- " + sent);
                }

                @Override
                public void handleCommand(int id, String command, String params, String originCommand) {
                    if (id == 1 && command.equals("ok")) {
                        WebsocketManager.this.parseHelloResponse(params);
                    } else if (command.equals("follow_sets")) {
                        WebsocketManager.this.parseFollowsets(params);
                    } else if (command.equals("do_authorize")) {
                        WebsocketManager.this.parseDoAuthorize(params);
                    } else if (originCommand.equals("update_follow_buttons")) {
                        if (command.equals("ok")) {
                            WebsocketManager.this.parseFollowingResponse(params);
                        } else if (command.equals("error")) {
                            WebsocketManager.this.listener.wsUserInfo("Failed updating follow buttons: " + params);
                        }
                    }
                }

                @Override
                public void handleConnect() {
                    WebsocketManager.this.setUser = null;
                    WebsocketManager.this.c.sendCommand("hello", JSONUtil.listToJSON(WebsocketManager.VERSION, false));
                    for (String room : WebsocketManager.this.getRooms()) {
                        WebsocketManager.this.subRoom(room);
                    }
                    WebsocketManager.this.c.sendCommand("ready", "0");
                }
            });
            this.c.init();
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(WebsocketManager.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void disconnect() {
        if (this.c != null) {
            this.c.disconnect();
        }
    }

    public synchronized void addRoom(String room) {
        if (!Helper.isValidStream(room)) {
            return;
        }
        this.connect();
        room = StringUtil.toLowerCase(room);
        if (this.rooms.add(room)) {
            this.subRoom(room);
        }
    }

    public synchronized void removeRoom(String room) {
        if (!Helper.isValidStream(room)) {
            return;
        }
        if (this.rooms.remove(room = StringUtil.toLowerCase(room))) {
            this.unsubRoom(room);
            this.removeEmotes(room);
            this.prevEmotesets.remove(room);
        }
    }

    public synchronized void setFollowing(String user, String room, String following) {
        if (this.c == null) {
            return;
        }
        String[] split = following.split(",");
        JSONArray rooms = new JSONArray();
        for (String item : split) {
            if (!Helper.isValidStream(item = item.trim())) continue;
            rooms.add(item);
        }
        JSONArray root = new JSONArray();
        root.add(room);
        root.add(rooms);
        if (!user.equals(this.setUser)) {
            this.c.sendCommand("setuser", "\"" + user + "\"");
            this.setUser = user;
        }
        this.c.sendCommand("update_follow_buttons", root.toJSONString());
    }

    private void subRoom(String room) {
        if (this.c != null) {
            this.c.sendCommand("sub", "\"room." + room + "\"");
        }
    }

    private void unsubRoom(String room) {
        if (this.c != null) {
            this.c.sendCommand("unsub", "\"room." + room + "\"");
        }
    }

    private void parseHelloResponse(String json) {
        try {
            JSONArray data = (JSONArray)this.parser.parse(json);
            String clientId = (String)data.get(0);
            long serverTime = ((Number)data.get(1)).longValue();
            this.serverTimeOffset = System.currentTimeMillis() - serverTime;
            LOGGER.info("[FFZ-WS] Server Time Offset: " + this.serverTimeOffset);
        }
        catch (Exception ex) {
            LOGGER.warning(String.format("[FFZ-WS] Error parsing 'hello' response: %s [%s]", ex, json));
        }
    }

    private void parseDoAuthorize(String json) {
        try {
            String code = (String)this.parser.parse(json);
            this.listener.authorizeUser(code);
        }
        catch (Exception ex) {
            LOGGER.warning(String.format("[FFZ-WS] Error parsing 'do_authorize' response: %s [%s]", ex, json));
        }
    }

    private void parseFollowingResponse(String json) {
        try {
            JSONObject root = (JSONObject)this.parser.parse(json);
            int updatedClients = ((Number)root.get("updated_clients")).intValue();
            this.listener.wsUserInfo("Updated following buttons for " + updatedClients + " users.");
        }
        catch (Exception ex) {
            LOGGER.warning(String.format("[FFZ-WS] Error parsing 'update_follow_buttons' response: %s [%s]", ex, json));
        }
    }

    private void parseFollowsets(String json) {
        try {
            JSONObject data = (JSONObject)this.parser.parse(json);
            for (Object key : data.keySet()) {
                String room = StringUtil.toLowerCase((String)key);
                HashSet<Integer> emotesets = new HashSet<Integer>();
                for (Object set : (JSONArray)data.get(key)) {
                    emotesets.add(((Number)set).intValue());
                }
                if (this.prevEmotesets.containsKey(room) && this.prevEmotesets.get(room).equals(emotesets)) continue;
                this.fetchEmotes(room, emotesets);
                this.prevEmotesets.put(room, emotesets);
            }
        }
        catch (Exception ex) {
            LOGGER.warning(String.format("[FFZ-WS] Error parsing 'follow_sets': %s [%s]", ex, json));
        }
    }

    private void fetchEmotes(String room, Set<Integer> emotesets) {
        HashSet<Emoticon> result = new HashSet<Emoticon>();
        for (int set : emotesets) {
            Set<Emoticon> fetched = this.fetchEmoteSet(room, set);
            for (Emoticon emoteToAdd : fetched) {
                for (Emoticon emote : result) {
                    if (!emote.equals(emoteToAdd)) continue;
                    emote.addInfos(emoteToAdd.getInfos());
                    break;
                }
                result.add(emoteToAdd);
            }
        }
        EmoticonUpdate.Builder updateBuilder = new EmoticonUpdate.Builder(result);
        updateBuilder.setTypeToRemove(Emoticon.Type.FFZ);
        updateBuilder.setSubTypeToRemove(Emoticon.SubType.EVENT);
        updateBuilder.setRoomToRemove(room);
        this.listener.channelEmoticonsReceived(updateBuilder.build());
    }

    private void removeEmotes(String room) {
        EmoticonUpdate.Builder updateBuilder = new EmoticonUpdate.Builder(null);
        updateBuilder.setTypeToRemove(Emoticon.Type.FFZ);
        updateBuilder.setSubTypeToRemove(Emoticon.SubType.EVENT);
        updateBuilder.setRoomToRemove(room);
        this.listener.channelEmoticonsReceived(updateBuilder.build());
    }

    private Set<Emoticon> fetchEmoteSet(String room, int emoteset) {
        UrlRequest r = new UrlRequest("https://api.frankerfacez.com/v1/set/" + emoteset);
        UrlRequest.FullResult result = r.sync();
        if (result.getResult() != null) {
            Set<Emoticon> emotes = FrankerFaceZParsing.parseSetEmotes(result.getResult(), Emoticon.SubType.EVENT, room);
            return emotes;
        }
        return new HashSet<Emoticon>();
    }
}

