/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.gif;

import chatty.util.ElapsedTime;
import chatty.util.gif.AnimatedImage;
import java.awt.Dimension;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;

public class AnimatedImageSource
implements ImageProducer {
    private static final Logger LOGGER = Logger.getLogger(AnimatedImageSource.class.getName());
    private static final int INACTIVITY_SECONDS = 5;
    private final Set<ImageConsumer> consumers = new HashSet<ImageConsumer>();
    private final AnimatedImage image;
    private final int width;
    private final int height;
    private final ColorModel colorModel;
    private int[] pixels;
    private int currentFrame = -1;
    private Thread thread;
    private ElapsedTime noConsumersTime;
    private boolean errorOccured;
    public static volatile int ANIMATION_PAUSE = -1;

    public AnimatedImageSource(AnimatedImage image) {
        this.image = image;
        Dimension size = image.getSize();
        this.width = size.width;
        this.height = size.height;
        this.colorModel = ColorModel.getRGBdefault();
    }

    @Override
    public void startProduction(ImageConsumer ic) {
        this.addConsumer(ic);
    }

    @Override
    public synchronized void addConsumer(ImageConsumer ic) {
        if (this.isConsumer(ic)) {
            return;
        }
        this.consumers.add(ic);
        this.initConsumer(ic);
        this.sendFrame(ic);
        this.startThread();
    }

    @Override
    public synchronized void removeConsumer(ImageConsumer ic) {
        this.consumers.remove(ic);
    }

    @Override
    public synchronized boolean isConsumer(ImageConsumer ic) {
        return this.consumers.contains(ic);
    }

    @Override
    public void requestTopDownLeftRightResend(ImageConsumer ic) {
    }

    public AnimatedImage getAnimatedImage() {
        return this.image;
    }

    private void startThread() {
        if (this.errorOccured) {
            return;
        }
        if (this.thread == null || !this.thread.isAlive()) {
            this.thread = new Thread(() -> {
                do {
                    if (this.isActive()) {
                        this.nextFrame();
                    } else {
                        int pauseFrame = 0;
                        switch (ANIMATION_PAUSE) {
                            case 0: {
                                pauseFrame = 0;
                                break;
                            }
                            case 1: {
                                pauseFrame = this.currentFrame;
                                break;
                            }
                            case 2: {
                                pauseFrame = this.image.getPreferredPauseFrame();
                            }
                        }
                        if (pauseFrame < 0) {
                            pauseFrame = 0;
                        }
                        if (pauseFrame != this.currentFrame || !this.hasPixels()) {
                            this.currentFrame = pauseFrame - 1;
                            this.nextFrame();
                        }
                    }
                    try {
                        Thread.sleep(this.getDelay());
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                } while (!this.checkStopThread() && !Thread.interrupted());
                this.threadStopped();
            }, "AnimatedImage" + (this.image.getName() != null ? "-" + this.image.getName() : ""));
            this.thread.setDaemon(true);
            this.thread.setPriority(2);
            this.thread.start();
        }
    }

    private synchronized int getDelay() {
        return this.image.getDelay(this.currentFrame);
    }

    private synchronized boolean isActive() {
        return ANIMATION_PAUSE == -1;
    }

    private synchronized boolean hasPixels() {
        return this.pixels != null;
    }

    private synchronized boolean checkStopThread() {
        if (this.errorOccured) {
            return true;
        }
        if (!this.consumers.isEmpty()) {
            this.noConsumersTime = null;
            return false;
        }
        if (this.noConsumersTime == null) {
            this.noConsumersTime = new ElapsedTime(true);
        }
        return this.noConsumersTime.secondsElapsed(5);
    }

    private synchronized void threadStopped() {
        this.thread = null;
        this.pixels = null;
    }

    private synchronized void nextFrame() {
        this.currentFrame = (this.currentFrame + 1) % this.image.getFrameCount();
        if (this.pixels == null) {
            this.pixels = new int[this.width * this.height];
        }
        try {
            this.image.getFrame(this.currentFrame, this.pixels);
        }
        catch (Exception ex) {
            LOGGER.warning(String.format("Error getting %s frame: %s", this.image.getName(), ex));
            this.errorOccured = true;
        }
        for (ImageConsumer ic : this.consumers) {
            this.sendFrame(ic);
        }
    }

    private void sendFrame(ImageConsumer ic) {
        if (this.pixels == null) {
            return;
        }
        if (this.isConsumer(ic)) {
            ic.setPixels(0, 0, this.width, this.height, this.colorModel, this.pixels, 0, this.width);
        }
        if (this.isConsumer(ic)) {
            if (this.image.getFrameCount() == 1) {
                ic.imageComplete(3);
            } else {
                ic.imageComplete(2);
            }
        }
    }

    private void initConsumer(ImageConsumer ic) {
        if (this.isConsumer(ic)) {
            ic.setDimensions(this.width, this.height);
        }
        if (this.isConsumer(ic)) {
            ic.setColorModel(this.colorModel);
        }
        if (this.isConsumer(ic)) {
            if (this.image.getFrameCount() == 1) {
                ic.setHints(30);
            } else {
                ic.setHints(6);
            }
        }
    }
}

