/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.gif;

import chatty.util.BatchAction;
import chatty.util.gif.AnimatedImage;
import chatty.util.settings.Settings;
import java.awt.KeyboardFocusManager;

public class FocusUpdates {
    private static final String PAUSE_SETTING = "animationPause";
    private static final String PAUSE_FRAME_SETTING = "animationPauseFrame";

    public static void set(Settings settings) {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("focusedWindow", e -> BatchAction.queue(FocusUpdates.class, 100L, false, true, () -> FocusUpdates.update(settings, e.getNewValue() != null)));
        settings.addSettingChangeListener((setting, type, value) -> {
            if (setting.equals(PAUSE_SETTING)) {
                FocusUpdates.update(settings, true);
            }
        });
    }

    private static void update(Settings settings, boolean active) {
        boolean alwaysOff = settings.getLong(PAUSE_SETTING) == 0L;
        boolean activityOff = !active && settings.getLong(PAUSE_SETTING) == 1L;
        int pauseState = -1;
        if (alwaysOff || activityOff) {
            pauseState = (int)settings.getLong(PAUSE_FRAME_SETTING);
        }
        AnimatedImage.setAnimationPause(pauseState);
    }
}

