/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.gif;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.IIOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageOutputStream;

public class GifSequenceWriter {
    protected ImageWriter gifWriter = GifSequenceWriter.getWriter();
    protected ImageWriteParam imageWriteParam = this.gifWriter.getDefaultWriteParam();
    protected IIOMetadata imageMetaData;
    private final String metaFormatName;
    private final boolean hasTransparency;

    public GifSequenceWriter(ImageOutputStream outputStream, int imageType, boolean loopContinuously, boolean hasTransparency) throws IIOException, IOException {
        ImageTypeSpecifier imageTypeSpecifier = ImageTypeSpecifier.createFromBufferedImageType(imageType);
        this.imageMetaData = this.gifWriter.getDefaultImageMetadata(imageTypeSpecifier, this.imageWriteParam);
        this.metaFormatName = this.imageMetaData.getNativeMetadataFormatName();
        IIOMetadataNode root = (IIOMetadataNode)this.imageMetaData.getAsTree(this.metaFormatName);
        IIOMetadataNode commentsNode = GifSequenceWriter.getNode(root, "CommentExtensions");
        commentsNode.setAttribute("CommentExtension", "Created by MAH");
        IIOMetadataNode appEntensionsNode = GifSequenceWriter.getNode(root, "ApplicationExtensions");
        IIOMetadataNode child = new IIOMetadataNode("ApplicationExtension");
        child.setAttribute("applicationID", "NETSCAPE");
        child.setAttribute("authenticationCode", "2.0");
        int loop = loopContinuously ? 0 : 1;
        child.setUserObject(new byte[]{1, (byte)(loop & 0xFF), (byte)(loop >> 8 & 0xFF)});
        appEntensionsNode.appendChild(child);
        this.imageMetaData.setFromTree(this.metaFormatName, root);
        this.gifWriter.setOutput(outputStream);
        this.gifWriter.prepareWriteSequence(null);
        this.hasTransparency = hasTransparency;
    }

    public void writeToSequence(RenderedImage img, int frameDelay) throws IOException {
        this.writeToSequence(img, frameDelay, true);
    }

    public void writeToSequence(RenderedImage img, int frameDelay, boolean capDelay) throws IOException {
        if (capDelay) {
            frameDelay = GifSequenceWriter.capDelay(frameDelay);
        }
        this.setGceOptions(frameDelay);
        this.gifWriter.writeToSequence(new IIOImage(img, null, this.imageMetaData), this.imageWriteParam);
    }

    private void setGceOptions(int frameDelay) throws IOException {
        IIOMetadataNode root = (IIOMetadataNode)this.imageMetaData.getAsTree(this.metaFormatName);
        IIOMetadataNode graphicsControlExtensionNode = GifSequenceWriter.getNode(root, "GraphicControlExtension");
        graphicsControlExtensionNode.setAttribute("disposalMethod", this.hasTransparency ? "restoreToBackgroundColor" : "doNotDispose");
        graphicsControlExtensionNode.setAttribute("userInputFlag", "FALSE");
        graphicsControlExtensionNode.setAttribute("transparentColorFlag", "FALSE");
        graphicsControlExtensionNode.setAttribute("transparentColorIndex", "0");
        graphicsControlExtensionNode.setAttribute("delayTime", Integer.toString(frameDelay / 10));
        this.imageMetaData.setFromTree(this.metaFormatName, root);
    }

    public void close() throws IOException {
        this.gifWriter.endWriteSequence();
    }

    private static ImageWriter getWriter() throws IIOException {
        Iterator<ImageWriter> iter = ImageIO.getImageWritersBySuffix("gif");
        if (!iter.hasNext()) {
            throw new IIOException("No GIF Image Writers Exist");
        }
        return iter.next();
    }

    private static IIOMetadataNode getNode(IIOMetadataNode rootNode, String nodeName) {
        int nNodes = rootNode.getLength();
        for (int i = 0; i < nNodes; ++i) {
            if (rootNode.item(i).getNodeName().compareToIgnoreCase(nodeName) != 0) continue;
            return (IIOMetadataNode)rootNode.item(i);
        }
        IIOMetadataNode node = new IIOMetadataNode(nodeName);
        rootNode.appendChild(node);
        return node;
    }

    public static GifSequenceWriter create(ImageOutputStream output, BufferedImage image) throws IOException {
        return new GifSequenceWriter(output, image.getType(), true, GifSequenceWriter.hasTransparency(image));
    }

    public static boolean hasTransparency(BufferedImage image) {
        if (image.getColorModel().hasAlpha()) {
            for (int x = 0; x < image.getWidth(); ++x) {
                for (int y = 0; y < image.getHeight(); ++y) {
                    int alpha = image.getRGB(x, y) >> 24 & 0xFF;
                    if (alpha != 0) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static int capDelay(int delay) {
        if (delay <= 10) {
            return 100;
        }
        return delay;
    }
}

