/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.gif;

import chatty.util.ImageCache;
import chatty.util.gif.GifDecoderFMS;
import chatty.util.gif.GifSequenceWriter;
import chatty.util.gif.ListAnimatedImage;
import chatty.util.gif.ListAnimatedImageFrame;
import chatty.util.settings.Settings;
import chatty.util.seventv.WebPUtil;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.ImageIcon;

public class GifUtil {
    private static final Logger LOGGER = Logger.getLogger(GifUtil.class.getName());
    private static Settings settings;

    public static ImageCache.ImageResult getGifFromUrl(ImageCache.ImageRequest request) throws Exception {
        ImageCache.ImageResult result = null;
        URLConnection c = request.getLoadFromURL().openConnection();
        try (InputStream input = c.getInputStream();){
            byte[] imageData = GifUtil.readAllBytes(input);
            result = GifUtil.loadAsGif(imageData, request);
            if (result == null) {
                result = GifUtil.loadDefault(imageData, request);
            }
            if (result == null) {
                result = WebPUtil.decode(imageData, request);
            }
            if (result != null && !result.isValidImage()) {
                result.icon.getImage().flush();
                ImageCache.ImageResult imageResult = null;
                return imageResult;
            }
        }
        return result;
    }

    private static ImageCache.ImageResult loadAsGif(byte[] imageData, ImageCache.ImageRequest request) {
        try {
            if (settings != null && settings.getBoolean("legacyAnimations")) {
                return GifUtil.fixGifFps(imageData, request);
            }
            return GifUtil.createGif(imageData, request);
        }
        catch (Exception ex) {
            return null;
        }
    }

    private static ImageCache.ImageResult loadDefault(byte[] imageData, ImageCache.ImageRequest request) throws IOException {
        boolean iconValid;
        BufferedImage loadedImage;
        ImageIcon icon = new ImageIcon(imageData);
        if (icon.getIconWidth() == -1 && (loadedImage = ImageIO.read(new ByteArrayInputStream(imageData))) != null) {
            icon.setImage(loadedImage);
            icon.setDescription("ImageIO");
        }
        boolean bl = iconValid = icon.getImageLoadStatus() != 4 && icon.getIconWidth() != -1;
        if (iconValid) {
            return request.finishIcon(icon, false);
        }
        return null;
    }

    private static ImageCache.ImageResult fixGifFps(byte[] imageData, ImageCache.ImageRequest request) throws IOException {
        Dimension actualBaseSize;
        GifDecoderFMS gif = new GifDecoderFMS();
        gif.read(new ByteArrayInputStream(imageData));
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (ImageOutputStream output = ImageIO.createImageOutputStream(bos);){
            BufferedImage firstImage = gif.getFrame(0);
            actualBaseSize = request.getCorrectedSizeFromImage(firstImage);
            Dimension scaledSize = request.getScaledSizeIfNecessary(actualBaseSize);
            GifSequenceWriter w = GifSequenceWriter.create(output, firstImage);
            for (int i = 0; i < gif.getFrameCount(); ++i) {
                BufferedImage frame = gif.getFrame(i);
                if (scaledSize != null) {
                    frame = GifUtil.resize(frame, scaledSize.width, scaledSize.height);
                }
                w.writeToSequence(frame, gif.getDelay(i));
            }
            w.close();
        }
        ImageIcon icon = new ImageIcon(bos.toByteArray());
        icon.setDescription("GIF");
        return new ImageCache.ImageResult(icon, actualBaseSize, true);
    }

    public static BufferedImage resize(BufferedImage image, int width, int height) {
        Image scaledImage = image.getScaledInstance(width, height, 4);
        BufferedImage result = new BufferedImage(width, height, 2);
        result.getGraphics().drawImage(scaledImage, 0, 0, null);
        result.getGraphics().dispose();
        return result;
    }

    private static byte[] readAllBytes(InputStream input) throws IOException {
        int length;
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((length = input.read(buffer, 0, buffer.length)) != -1) {
            result.write(buffer, 0, length);
        }
        return result.toByteArray();
    }

    private static ImageCache.ImageResult createGif(byte[] data, ImageCache.ImageRequest request) throws Exception {
        String name = request.getRequestedURL().toString();
        GifDecoderFMS gif = new GifDecoderFMS();
        gif.read(new ByteArrayInputStream(data));
        Dimension size = new Dimension();
        Dimension actualBaseSize = request.getCorrectedSizeFromImage(gif.getFrame(0));
        Dimension scaledSize = request.getScaledSizeIfNecessary(actualBaseSize);
        ArrayList<ListAnimatedImageFrame> frames = new ArrayList<ListAnimatedImageFrame>();
        for (int i = 0; i < gif.getFrameCount(); ++i) {
            BufferedImage image = gif.getFrame(i);
            if (scaledSize != null) {
                image = GifUtil.resize(image, scaledSize.width, scaledSize.height);
            }
            size = new Dimension(image.getWidth(), image.getHeight());
            int delay = GifUtil.capDelay(gif.getDelay(i));
            frames.add(new ListAnimatedImageFrame(image, delay));
        }
        ImageIcon icon = new ImageIcon(new ListAnimatedImage(frames, size.width, size.height, name).createImage());
        icon.setDescription("GIF");
        return new ImageCache.ImageResult(icon, actualBaseSize, true);
    }

    private static int capDelay(int delay) {
        if (delay <= 10) {
            return 100;
        }
        return delay;
    }

    public static void setSettings(Settings settings) {
        GifUtil.settings = settings;
    }
}

