/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.gif;

import chatty.util.gif.AnimatedImage;
import chatty.util.gif.AnimatedImageSource;
import chatty.util.gif.ListAnimatedImageFrame;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.util.List;

public class ListAnimatedImage
implements AnimatedImage {
    private final List<ListAnimatedImageFrame> frames;
    private final Dimension size;
    private final String name;
    private final int preferredPauseFrame;

    public ListAnimatedImage(List<ListAnimatedImageFrame> frames, int width, int height, String name) {
        this.frames = frames;
        this.size = new Dimension(width, height);
        this.name = name;
        int highestVisiblePixelCount = 0;
        int mostVisibleFrame = 0;
        for (int i = 0; i < frames.size(); ++i) {
            int visiblePixelCount = frames.get(i).getVisiblePixelCount();
            if (visiblePixelCount <= highestVisiblePixelCount) continue;
            mostVisibleFrame = i;
            highestVisiblePixelCount = visiblePixelCount;
        }
        this.preferredPauseFrame = highestVisiblePixelCount == 0 || frames.get(0).getVisiblePixelCount() * 10 / highestVisiblePixelCount > 7 ? 0 : mostVisibleFrame;
    }

    @Override
    public void getFrame(int frame, int[] pixels) throws Exception {
        this.frames.get(frame).getImage(pixels);
    }

    @Override
    public int getFrameCount() {
        return this.frames.size();
    }

    @Override
    public int getDelay(int frame) {
        return this.frames.get(frame).getDelay();
    }

    @Override
    public Dimension getSize() {
        return this.size;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getPreferredPauseFrame() {
        return this.preferredPauseFrame;
    }

    public Image createImage() {
        return Toolkit.getDefaultToolkit().createImage(new AnimatedImageSource(this));
    }
}

