/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.gif;

import chatty.util.gif.ARGBBuffer;
import chatty.util.gif.PNGDecoder;
import com.pngencoder.PngEncoder;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class ListAnimatedImageFrame {
    private final byte[] compressed;
    private final int delay;
    private final int width;
    private final int height;
    private final int visiblePixelCount;

    public ListAnimatedImageFrame(BufferedImage image, int delay) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            new PngEncoder().withBufferedImage(image).withCompressionLevel(1).toStream(baos);
            this.compressed = baos.toByteArray();
        }
        this.delay = delay;
        this.width = image.getWidth();
        this.height = image.getHeight();
        int transparentPixelCount = 0;
        for (int x = 0; x < image.getWidth(); ++x) {
            for (int y = 0; y < image.getHeight(); ++y) {
                int pixel = image.getRGB(x, y);
                if ((pixel & 0xFF000000) != 0) continue;
                ++transparentPixelCount;
            }
        }
        this.visiblePixelCount = this.width * this.height - transparentPixelCount;
    }

    public void getImage(int[] pixels) throws IOException {
        PNGDecoder decoder = new PNGDecoder(new ByteArrayInputStream(this.compressed));
        decoder.decode(new ARGBBuffer(pixels), this.width * 4, PNGDecoder.Format.RGBA);
    }

    public int getDelay() {
        return this.delay;
    }

    public int getVisiblePixelCount() {
        return this.visiblePixelCount;
    }
}

