/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.gif;

import chatty.gui.GuiUtil;
import chatty.util.Debugging;
import chatty.util.ImageCache;
import chatty.util.gif.AnimatedImage;
import chatty.util.gif.AnimatedImageSource;
import chatty.util.gif.GifUtil;
import chatty.util.gif.ListAnimatedImage;
import chatty.util.gif.ListAnimatedImageFrame;
import chatty.util.gif.OverlayListAnimatedImage;
import chatty.util.seventv.WebPUtil;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class Overlay {
    public static ImageIcon overlayNew(LinkedHashMap<ImageIcon, Integer> overlay) throws Exception {
        if (overlay == null || overlay.isEmpty()) {
            return null;
        }
        if (overlay.size() == 1) {
            return overlay.entrySet().iterator().next().getKey();
        }
        ImageIcon base = null;
        int width = 0;
        int height = 0;
        int oh = 0;
        for (Map.Entry<ImageIcon, Integer> entry : overlay.entrySet()) {
            ImageIcon imageIcon = entry.getKey();
            if (base == null) {
                base = entry.getKey();
            }
            width = Integer.max(width, imageIcon.getIconWidth());
            height = Integer.max(height, imageIcon.getIconHeight());
            int offset = Math.abs((int)((double)entry.getValue().intValue() / 100.0 * (double)imageIcon.getIconHeight()));
            int inclOffset = imageIcon.getIconHeight() + offset;
            if (inclOffset <= height) continue;
            oh += inclOffset - height;
            height = inclOffset;
        }
        if (Overlay.containsAnimatedImageSource(overlay)) {
            ArrayList<ListAnimatedImage> images = new ArrayList<ListAnimatedImage>();
            for (Map.Entry<ImageIcon, Integer> entry : overlay.entrySet()) {
                ImageIcon icon = entry.getKey();
                int offset = (int)((double)entry.getValue().intValue() / 100.0 * (double)icon.getIconHeight());
                if (icon.getImage().getSource() instanceof AnimatedImageSource) {
                    int[] pixels = new int[icon.getIconWidth() * icon.getIconHeight()];
                    AnimatedImage anim = ((AnimatedImageSource)icon.getImage().getSource()).getAnimatedImage();
                    ArrayList<ListAnimatedImageFrame> frames = new ArrayList<ListAnimatedImageFrame>();
                    for (int i = 0; i < anim.getFrameCount(); ++i) {
                        BufferedImage bi = Overlay.getImage(pixels, anim, i);
                        frames.add(Overlay.createFrame(bi, bi.getWidth(), bi.getHeight(), width, height, offset, oh, anim.getDelay(i)));
                    }
                    images.add(new ListAnimatedImage(frames, width, height, anim.getName()));
                    continue;
                }
                ArrayList<ListAnimatedImageFrame> frames = new ArrayList<ListAnimatedImageFrame>();
                frames.add(Overlay.createFrame(icon.getImage(), icon.getIconWidth(), icon.getIconHeight(), width, height, offset, oh, Integer.MAX_VALUE));
                images.add(new ListAnimatedImage(frames, width, height, "Static Image"));
            }
            return new ImageIcon(new OverlayListAnimatedImage(images, width, height, "Overlayed").createImage());
        }
        BufferedImage img = new BufferedImage(width, height, 2);
        Graphics2D graphics2D = img.createGraphics();
        for (Map.Entry<ImageIcon, Integer> entry : overlay.entrySet()) {
            ImageIcon icon = entry.getKey();
            int offset = (int)((double)entry.getValue().intValue() / 100.0 * (double)icon.getIconHeight());
            graphics2D.drawImage(icon.getImage(), (width - icon.getIconWidth()) / 2, (height - icon.getIconHeight()) / 2 + offset + oh, null);
        }
        graphics2D.dispose();
        return new ImageIcon(img);
    }

    private static ListAnimatedImageFrame createFrame(Image image, int imgWidth, int imgHeight, int targetWidth, int targetHeight, int offset, int oh, int delay) throws IOException {
        BufferedImage result = new BufferedImage(targetWidth, targetHeight, 2);
        Graphics2D g = result.createGraphics();
        g.drawImage(image, (targetWidth - imgWidth) / 2, (targetHeight - imgHeight) / 2 + offset + oh, null);
        g.dispose();
        return new ListAnimatedImageFrame(result, delay);
    }

    private static boolean containsAnimatedImageSource(LinkedHashMap<ImageIcon, Integer> overlay) {
        for (ImageIcon icon : overlay.keySet()) {
            if (!(icon.getImage().getSource() instanceof AnimatedImageSource)) continue;
            return true;
        }
        return false;
    }

    private static BufferedImage getImage(int[] pixels, AnimatedImage anim, int index) throws Exception {
        anim.getFrame(index, pixels);
        int width = anim.getSize().width;
        int height = anim.getSize().height;
        DirectColorModel colorModel = new DirectColorModel(32, 0xFF0000, 65280, 255, -16777216);
        SampleModel sampleModel = ((ColorModel)colorModel).createCompatibleSampleModel(width, height);
        DataBufferInt db = new DataBufferInt(pixels, width * height);
        WritableRaster raster = WritableRaster.createWritableRaster(sampleModel, db, null);
        return new BufferedImage(colorModel, raster, false, new Hashtable());
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> WebPUtil.runIfWebPAvailable(() -> {
            try {
                JFrame dialog = new JFrame();
                dialog.setSize(100, 100);
                dialog.setLocationRelativeTo(null);
                dialog.setVisible(true);
                LinkedHashMap<ImageIcon, Integer> map = new LinkedHashMap<ImageIcon, Integer>();
                map.put(GifUtil.getGifFromUrl((ImageCache.ImageRequest)new ImageCache.ImageRequest((URL)new URL((String)"<url>"))).icon, 0);
                map.put(GifUtil.getGifFromUrl((ImageCache.ImageRequest)new ImageCache.ImageRequest((URL)new URL((String)"<url>"))).icon, 0);
                Debugging.command("overlayframe");
                dialog.add((Component)new JLabel("text", Overlay.overlayNew(map), 0), "Center");
                dialog.setDefaultCloseOperation(3);
                Timer timer = new Timer(100, e -> dialog.revalidate());
                timer.start();
            }
            catch (Exception ex) {
                Logger.getLogger(GuiUtil.class.getName()).log(Level.SEVERE, null, ex);
            }
        }));
    }
}

