/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.gif;

import chatty.util.gif.AnimatedImage;
import chatty.util.gif.AnimatedImageSource;
import chatty.util.gif.ListAnimatedImage;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.util.List;

public class OverlayListAnimatedImage
implements AnimatedImage {
    private final List<ListAnimatedImage> images;
    private final Dimension size;
    private final String name;
    private final ListAnimatedImage mainImage;
    private final int numFrames;
    private final int[] atFrame;
    private final int[] delays;
    private final int[][] buffer;
    private int lastRequestedFrame = -1;

    public OverlayListAnimatedImage(List<ListAnimatedImage> images, int width, int height, String name) {
        this.images = images;
        this.size = new Dimension(width, height);
        this.name = name;
        this.mainImage = images.get(0);
        this.numFrames = Math.max(this.mainImage.getFrameCount(), 2);
        this.atFrame = new int[images.size()];
        this.delays = new int[images.size()];
        this.buffer = new int[images.size()][width * height];
    }

    @Override
    public void getFrame(int requestedFrame, int[] pixels) throws Exception {
        int i;
        if (requestedFrame != (this.lastRequestedFrame + 1) % this.numFrames) {
            int i2;
            this.atFrame[0] = requestedFrame;
            for (i2 = 1; i2 < this.atFrame.length; ++i2) {
                this.atFrame[i2] = 0;
            }
            for (i2 = 0; i2 < this.delays.length; ++i2) {
                this.delays[i2] = 0;
            }
        }
        int lowestDelay = this.getLowestDelay();
        for (i = 0; i < this.delays.length; ++i) {
            if (this.delays[i] == lowestDelay) {
                ListAnimatedImage image = this.images.get(i);
                int imageFrameIndex = this.atFrame[i];
                image.getFrame(imageFrameIndex, this.buffer[i]);
                this.delays[i] = image.getDelay(imageFrameIndex);
                this.atFrame[i] = (imageFrameIndex + 1) % image.getFrameCount();
                continue;
            }
            int n = i;
            this.delays[n] = this.delays[n] - lowestDelay;
        }
        this.lastRequestedFrame = requestedFrame;
        System.arraycopy(this.buffer[0], 0, pixels, 0, pixels.length);
        for (i = 1; i < this.buffer.length; ++i) {
            OverlayListAnimatedImage.composite(this.buffer[i], pixels, pixels);
        }
    }

    private int getLowestDelay() {
        int lowest = Integer.MAX_VALUE;
        for (int delay : this.delays) {
            if (delay >= lowest) continue;
            lowest = delay;
        }
        return lowest;
    }

    @Override
    public int getFrameCount() {
        return this.numFrames;
    }

    @Override
    public int getDelay(int frame) {
        return this.getLowestDelay();
    }

    @Override
    public Dimension getSize() {
        return this.mainImage.getSize();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getPreferredPauseFrame() {
        return this.mainImage.getPreferredPauseFrame();
    }

    public Image createImage() {
        return Toolkit.getDefaultToolkit().createImage(new AnimatedImageSource(this));
    }

    private static void composite(int[] source1, int[] source2, int[] target) {
        for (int i = 0; i < source1.length; ++i) {
            int a1 = source1[i] >> 24 & 0xFF;
            int r1 = (source1[i] & 0xFF0000) >> 16;
            int g1 = (source1[i] & 0xFF00) >> 8;
            int b1 = source1[i] & 0xFF;
            int a2 = source2[i] >> 24 & 0xFF;
            int r2 = (source2[i] & 0xFF0000) >> 16;
            int g2 = (source2[i] & 0xFF00) >> 8;
            int b2 = source2[i] & 0xFF;
            int a = a1 + (255 - a1) * a2 / 255;
            int r = r1 * a1 / 255 + r2 * (255 - a1) * a2 / 65025;
            int g = g1 * a1 / 255 + g2 * (255 - a1) * a2 / 65025;
            int b = b1 * a1 / 255 + b2 * (255 - a1) * a2 / 65025;
            target[i] = a << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
        }
    }
}

