/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.history;

import chatty.Room;
import chatty.User;
import chatty.gui.components.settings.ChannelFormatter;
import chatty.util.SpecialMap;
import chatty.util.UrlRequest;
import chatty.util.api.Requests;
import chatty.util.history.HistoryMessage;
import chatty.util.history.QueuedMessage;
import chatty.util.irc.MsgTags;
import chatty.util.irc.ParsedMsg;
import chatty.util.settings.Settings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.logging.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class HistoryManager {
    private static final Logger LOGGER = Logger.getLogger(HistoryManager.class.getName());
    private final Settings settings;
    private static final ChannelFormatter channelFormater = new ChannelFormatter();
    private static final String STRHISTORYURL = "https://recent-messages.robotty.de/api/v2/recent-messages/";
    private final Object LOCK = new Object();
    private final Map<String, Long> latestMessageSeen = new HashMap<String, Long>();
    private final Set<String> requestPendingChannels = new HashSet<String>();
    private final SpecialMap<String, List<QueuedMessage>> queuedMessages = new SpecialMap(new HashMap(), () -> new ArrayList());

    public HistoryManager(Settings settings) {
        this.settings = settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMessageSeen(String stream) {
        Object object = this.LOCK;
        synchronized (object) {
            this.latestMessageSeen.put(stream, System.currentTimeMillis());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelClosed(String stream) {
        Object object = this.LOCK;
        synchronized (object) {
            this.latestMessageSeen.remove(stream);
            this.queuedMessages.remove(stream);
        }
    }

    public boolean isChannelExcluded(String channel) {
        return this.settings.listContains("historyServiceExcluded", channelFormater.format(channel));
    }

    public boolean isEnabled() {
        return this.settings.getBoolean("historyServiceEnabled");
    }

    private HistoryMessage transformStringToMessage(String rawMessage) {
        ParsedMsg parsed = ParsedMsg.parse(rawMessage);
        if (parsed == null) {
            return null;
        }
        if (parsed.getCommand().equals("PRIVMSG") && parsed.getParameters().has(1) && parsed.getParameters().get(0).startsWith("#")) {
            String message = parsed.getParameters().get(1);
            HistoryMessage result = new HistoryMessage();
            result.action = message.charAt(0) == '\u0001' && message.startsWith("ACTION", 1);
            result.message = result.action ? message.substring(7).trim() : message;
            result.tags = MsgTags.merge(parsed.getTags(), MsgTags.create("historic-timestamp", parsed.getTags().get("rm-received-ts")));
            result.userName = parsed.getNick();
            if (!result.userName.isEmpty()) {
                return result;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeRequest(String stream, Consumer<List<HistoryMessage>> listener) {
        String url = STRHISTORYURL + stream;
        long limit = this.settings.getLong("historyServiceLimit");
        if (limit <= 0L) {
            limit = 30L;
        }
        long timestampBefore = System.currentTimeMillis();
        long timestampAfter = System.currentTimeMillis() - 86400000L;
        Object object = this.LOCK;
        synchronized (object) {
            if (this.latestMessageSeen.containsKey(stream)) {
                timestampAfter = this.latestMessageSeen.get(stream);
            }
        }
        url = Requests.makeUrl(url, "limit", String.valueOf(limit), "before", String.valueOf(timestampBefore), "after", String.valueOf(timestampAfter));
        UrlRequest request = new UrlRequest(url);
        request.setLabel("ChatHistory/");
        request.setTimeouts(5000, 3000);
        request.async((resultText, responseCode) -> {
            ArrayList<HistoryMessage> result = new ArrayList<HistoryMessage>();
            if (responseCode == 200) {
                try {
                    JSONParser parser = new JSONParser();
                    JSONObject root = (JSONObject)parser.parse(resultText);
                    JSONArray jsArray = (JSONArray)root.get("messages");
                    for (int i = 0; i < jsArray.size(); ++i) {
                        HistoryMessage historyMsg = this.transformStringToMessage((String)jsArray.get(i));
                        if (historyMsg == null) continue;
                        result.add(historyMsg);
                    }
                }
                catch (ParseException ex) {
                    LOGGER.warning("Error requesting chat history: " + ex);
                }
            }
            listener.accept(result);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getHistoricChatMessages(Room room, Consumer<List<HistoryMessage>> listener) {
        Object object = this.LOCK;
        synchronized (object) {
            this.requestPendingChannels.add(room.getStream());
            this.queuedMessages.remove(room.getStream());
        }
        this.executeRequest(room.getStream(), listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<QueuedMessage> getQueuedMessages(String stream) {
        Object object = this.LOCK;
        synchronized (object) {
            this.requestPendingChannels.remove(stream);
            ArrayList<QueuedMessage> result = this.queuedMessages.remove(stream);
            return result != null ? result : new ArrayList<QueuedMessage>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addQueueMessage(User user, String text, MsgTags tags, boolean action) {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.requestPendingChannels.contains(user.getStream())) {
                this.queuedMessages.getPut(user.getStream()).add(new QueuedMessage(user, text, action, tags));
                return true;
            }
            return false;
        }
    }
}

